/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.streaming.api.datastream.CoGroupedStreams;
import org.apache.flink.testutils.DeeplyEqualsChecker;
import org.apache.flink.util.TaggedUnion;

class UnionSerializerTest
extends SerializerTestBase<TaggedUnion<Object, Object>> {
    public UnionSerializerTest() {
        super(new DeeplyEqualsChecker().withCustomCheck((o1, o2) -> o1 instanceof TaggedUnion && o2 instanceof TaggedUnion, (o1, o2, checker) -> {
            TaggedUnion union1 = (TaggedUnion)o1;
            TaggedUnion union2 = (TaggedUnion)o2;
            if (union1.isOne() && union2.isOne()) {
                return checker.deepEquals(union1.getOne(), union2.getOne());
            }
            if (union1.isTwo() && union2.isTwo()) {
                return checker.deepEquals(union1.getTwo(), union2.getTwo());
            }
            return false;
        }));
    }

    protected TypeSerializer<TaggedUnion<Object, Object>> createSerializer() {
        return new CoGroupedStreams.UnionSerializer((TypeSerializer)new KryoSerializer(Object.class, (SerializerConfig)new SerializerConfigImpl()), (TypeSerializer)new KryoSerializer(Object.class, (SerializerConfig)new SerializerConfigImpl()));
    }

    protected int getLength() {
        return -1;
    }

    protected Class<TaggedUnion<Object, Object>> getTypeClass() {
        return TaggedUnion.class;
    }

    protected TaggedUnion<Object, Object>[] getTestData() {
        return new TaggedUnion[]{TaggedUnion.one((Object)1), TaggedUnion.two((Object)"A"), TaggedUnion.one((Object)"C")};
    }
}

