/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyGroupRangeOffsets;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class KeyGroupRangeOffsetTest {
    KeyGroupRangeOffsetTest() {
    }

    @Test
    void testKeyGroupIntersection() {
        long[] offsets = new long[9];
        for (int i = 0; i < offsets.length; ++i) {
            offsets[i] = i;
        }
        int startKeyGroup = 2;
        KeyGroupRangeOffsets keyGroupRangeOffsets = new KeyGroupRangeOffsets(KeyGroupRange.of((int)startKeyGroup, (int)10), offsets);
        KeyGroupRangeOffsets intersection = keyGroupRangeOffsets.getIntersection(KeyGroupRange.of((int)3, (int)7));
        KeyGroupRangeOffsets expected = new KeyGroupRangeOffsets(KeyGroupRange.of((int)3, (int)7), Arrays.copyOfRange(offsets, 3 - startKeyGroup, 8 - startKeyGroup));
        Assertions.assertThat((Iterable)intersection).isEqualTo((Object)expected);
        Assertions.assertThat((Iterable)keyGroupRangeOffsets.getIntersection(keyGroupRangeOffsets.getKeyGroupRange())).isEqualTo((Object)keyGroupRangeOffsets);
        intersection = keyGroupRangeOffsets.getIntersection(KeyGroupRange.of((int)11, (int)13));
        Assertions.assertThat((Iterable)intersection.getKeyGroupRange()).isEqualTo((Object)KeyGroupRange.EMPTY_KEY_GROUP_RANGE);
        Assertions.assertThat((Iterator)intersection.iterator()).isExhausted();
        intersection = keyGroupRangeOffsets.getIntersection(KeyGroupRange.of((int)5, (int)13));
        expected = new KeyGroupRangeOffsets(KeyGroupRange.of((int)5, (int)10), Arrays.copyOfRange(offsets, 5 - startKeyGroup, 11 - startKeyGroup));
        Assertions.assertThat((Iterable)intersection).isEqualTo((Object)expected);
        intersection = keyGroupRangeOffsets.getIntersection(KeyGroupRange.of((int)0, (int)2));
        expected = new KeyGroupRangeOffsets(KeyGroupRange.of((int)2, (int)2), Arrays.copyOfRange(offsets, 2 - startKeyGroup, 3 - startKeyGroup));
        Assertions.assertThat((Iterable)intersection).isEqualTo((Object)expected);
    }

    @Test
    void testKeyGroupRangeOffsetsBasics() {
        int i;
        this.testKeyGroupRangeOffsetsBasicsInternal(0, 0);
        this.testKeyGroupRangeOffsetsBasicsInternal(0, 1);
        this.testKeyGroupRangeOffsetsBasicsInternal(1, 2);
        this.testKeyGroupRangeOffsetsBasicsInternal(42, 42);
        this.testKeyGroupRangeOffsetsBasicsInternal(3, 7);
        this.testKeyGroupRangeOffsetsBasicsInternal(0, Short.MAX_VALUE);
        this.testKeyGroupRangeOffsetsBasicsInternal(32766, Short.MAX_VALUE);
        Assertions.assertThatThrownBy(() -> this.testKeyGroupRangeOffsetsBasicsInternal(-3, 2)).isInstanceOf(IllegalArgumentException.class);
        KeyGroupRangeOffsets testNoGivenOffsets = new KeyGroupRangeOffsets(3, 7);
        for (i = 3; i <= 7; ++i) {
            testNoGivenOffsets.setKeyGroupOffset(i, (long)(i + 1));
        }
        for (i = 3; i <= 7; ++i) {
            Assertions.assertThat((long)testNoGivenOffsets.getKeyGroupOffset(i)).isEqualTo((long)(i + 1));
        }
    }

    private void testKeyGroupRangeOffsetsBasicsInternal(int startKeyGroup, int endKeyGroup) {
        long[] offsets = new long[endKeyGroup - startKeyGroup + 1];
        for (int i = 0; i < offsets.length; ++i) {
            offsets[i] = i;
        }
        KeyGroupRangeOffsets keyGroupRange = new KeyGroupRangeOffsets(startKeyGroup, endKeyGroup, offsets);
        KeyGroupRangeOffsets sameButDifferentConstr = new KeyGroupRangeOffsets(KeyGroupRange.of((int)startKeyGroup, (int)endKeyGroup), offsets);
        Assertions.assertThat((Iterable)sameButDifferentConstr).isEqualTo((Object)keyGroupRange);
        int numberOfKeyGroup = keyGroupRange.getKeyGroupRange().getNumberOfKeyGroups();
        Assertions.assertThat((int)numberOfKeyGroup).isEqualTo(Math.max(0, endKeyGroup - startKeyGroup + 1));
        if (numberOfKeyGroup > 0) {
            int i;
            Assertions.assertThat((int)keyGroupRange.getKeyGroupRange().getStartKeyGroup()).isEqualTo(startKeyGroup);
            Assertions.assertThat((int)keyGroupRange.getKeyGroupRange().getEndKeyGroup()).isEqualTo(endKeyGroup);
            int c = startKeyGroup;
            for (Tuple2 tuple : keyGroupRange) {
                Assertions.assertThat((Integer)((Integer)tuple.f0)).isEqualTo(c);
                Assertions.assertThat((Iterable)keyGroupRange.getKeyGroupRange()).contains((Object[])new Integer[]{(Integer)tuple.f0});
                Assertions.assertThat((Long)((Long)tuple.f1)).isEqualTo((long)c - (long)startKeyGroup);
                ++c;
            }
            for (int i2 = startKeyGroup; i2 <= endKeyGroup; ++i2) {
                Assertions.assertThat((long)keyGroupRange.getKeyGroupOffset(i2)).isEqualTo((long)(i2 - startKeyGroup));
            }
            int newOffset = 42;
            for (i = startKeyGroup; i <= endKeyGroup; ++i) {
                keyGroupRange.setKeyGroupOffset(i, (long)newOffset);
                ++newOffset;
            }
            for (i = startKeyGroup; i <= endKeyGroup; ++i) {
                Assertions.assertThat((long)keyGroupRange.getKeyGroupOffset(i)).isEqualTo((long)(42 + i - startKeyGroup));
            }
            Assertions.assertThat((int)c).isEqualTo(endKeyGroup + 1);
            Assertions.assertThat((Iterable)keyGroupRange.getKeyGroupRange()).doesNotContain((Object[])new Integer[]{startKeyGroup - 1});
            Assertions.assertThat((Iterable)keyGroupRange.getKeyGroupRange()).doesNotContain((Object[])new Integer[]{endKeyGroup + 1});
        } else {
            Assertions.assertThat((Iterable)keyGroupRange).isEqualTo((Object)KeyGroupRange.EMPTY_KEY_GROUP_RANGE);
        }
    }
}

