/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.flink.runtime.checkpoint.metadata.CheckpointTestUtils;
import org.apache.flink.runtime.state.DiscardRecordedStateObject;
import org.apache.flink.runtime.state.IncrementalKeyedStateHandle;
import org.apache.flink.runtime.state.IncrementalRemoteKeyedStateHandle;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.SharedStateRegistryImpl;
import org.apache.flink.runtime.state.SharedStateRegistryKey;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.apache.flink.util.TernaryBoolean;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class IncrementalRemoteKeyedStateHandleTest {
    IncrementalRemoteKeyedStateHandleTest() {
    }

    @Test
    void testUnregisteredDiscarding() throws Exception {
        IncrementalRemoteKeyedStateHandle stateHandle = IncrementalRemoteKeyedStateHandleTest.create(new Random(42L));
        stateHandle.discardState();
        for (IncrementalKeyedStateHandle.HandleAndLocalPath handleAndLocalPath : stateHandle.getPrivateState()) {
            DiscardRecordedStateObject.verifyDiscard((StateObject)handleAndLocalPath.getHandle(), TernaryBoolean.TRUE);
        }
        for (IncrementalKeyedStateHandle.HandleAndLocalPath handleAndLocalPath : stateHandle.getSharedState()) {
            DiscardRecordedStateObject.verifyDiscard((StateObject)handleAndLocalPath.getHandle(), TernaryBoolean.TRUE);
        }
        ((StreamStateHandle)Mockito.verify((Object)stateHandle.getMetaDataStateHandle())).discardState();
    }

    @Test
    void testSharedStateDeRegistration() throws Exception {
        SharedStateRegistryKey registryKey;
        StreamStateHandle handle;
        SharedStateRegistry registry = (SharedStateRegistry)Mockito.spy((Object)new SharedStateRegistryImpl());
        IncrementalRemoteKeyedStateHandle stateHandle1 = IncrementalRemoteKeyedStateHandleTest.create(new Random(42L));
        IncrementalRemoteKeyedStateHandle stateHandle2 = IncrementalRemoteKeyedStateHandleTest.create(new Random(42L));
        for (IncrementalKeyedStateHandle.HandleAndLocalPath handleAndLocalPath : stateHandle1.getSharedState()) {
            DiscardRecordedStateObject.verifyDiscard((StateObject)handleAndLocalPath.getHandle(), TernaryBoolean.FALSE);
        }
        for (IncrementalKeyedStateHandle.HandleAndLocalPath handleAndLocalPath : stateHandle2.getSharedState()) {
            DiscardRecordedStateObject.verifyDiscard((StateObject)handleAndLocalPath.getHandle(), TernaryBoolean.FALSE);
        }
        stateHandle1.registerSharedStates(registry, 0L);
        registry.checkpointCompleted(0L);
        stateHandle2.registerSharedStates(registry, 0L);
        for (IncrementalKeyedStateHandle.HandleAndLocalPath handleAndLocalPath : stateHandle1.getSharedState()) {
            handle = handleAndLocalPath.getHandle();
            registryKey = SharedStateRegistryKey.forStreamStateHandle((StreamStateHandle)handle);
            ((SharedStateRegistry)Mockito.verify((Object)registry, (VerificationMode)Mockito.times((int)2))).registerReference(registryKey, handle, 0L);
        }
        for (IncrementalKeyedStateHandle.HandleAndLocalPath handleAndLocalPath : stateHandle2.getSharedState()) {
            handle = handleAndLocalPath.getHandle();
            registryKey = SharedStateRegistryKey.forStreamStateHandle((StreamStateHandle)handle);
            ((SharedStateRegistry)Mockito.verify((Object)registry, (VerificationMode)Mockito.times((int)2))).registerReference(registryKey, handle, 0L);
        }
        stateHandle1.discardState();
        for (IncrementalKeyedStateHandle.HandleAndLocalPath handleAndLocalPath : stateHandle1.getSharedState()) {
            DiscardRecordedStateObject.verifyDiscard((StateObject)handleAndLocalPath.getHandle(), TernaryBoolean.FALSE);
        }
        for (IncrementalKeyedStateHandle.HandleAndLocalPath handleAndLocalPath : stateHandle2.getSharedState()) {
            DiscardRecordedStateObject.verifyDiscard((StateObject)handleAndLocalPath.getHandle(), TernaryBoolean.FALSE);
        }
        for (IncrementalKeyedStateHandle.HandleAndLocalPath handleAndLocalPath : stateHandle1.getPrivateState()) {
            ((StreamStateHandle)Mockito.verify((Object)handleAndLocalPath.getHandle(), (VerificationMode)Mockito.times((int)1))).discardState();
        }
        for (IncrementalKeyedStateHandle.HandleAndLocalPath handleAndLocalPath : stateHandle2.getPrivateState()) {
            ((StreamStateHandle)Mockito.verify((Object)handleAndLocalPath.getHandle(), (VerificationMode)Mockito.times((int)0))).discardState();
        }
        ((StreamStateHandle)Mockito.verify((Object)stateHandle1.getMetaDataStateHandle(), (VerificationMode)Mockito.times((int)1))).discardState();
        ((StreamStateHandle)Mockito.verify((Object)stateHandle2.getMetaDataStateHandle(), (VerificationMode)Mockito.times((int)0))).discardState();
        stateHandle2.discardState();
        registry.unregisterUnusedState(Long.MAX_VALUE);
        for (IncrementalKeyedStateHandle.HandleAndLocalPath handleAndLocalPath : stateHandle1.getSharedState()) {
            DiscardRecordedStateObject.verifyDiscard((StateObject)handleAndLocalPath.getHandle(), TernaryBoolean.TRUE);
        }
        for (IncrementalKeyedStateHandle.HandleAndLocalPath handleAndLocalPath : stateHandle2.getSharedState()) {
            DiscardRecordedStateObject.verifyDiscard((StateObject)handleAndLocalPath.getHandle(), TernaryBoolean.TRUE);
        }
        ((StreamStateHandle)Mockito.verify((Object)stateHandle1.getMetaDataStateHandle(), (VerificationMode)Mockito.times((int)1))).discardState();
        ((StreamStateHandle)Mockito.verify((Object)stateHandle2.getMetaDataStateHandle(), (VerificationMode)Mockito.times((int)1))).discardState();
    }

    @Test
    void testSharedStateReRegistration() throws Exception {
        SharedStateRegistry stateRegistryA = (SharedStateRegistry)Mockito.spy((Object)new SharedStateRegistryImpl());
        IncrementalRemoteKeyedStateHandle stateHandleX = IncrementalRemoteKeyedStateHandleTest.create(new Random(1L));
        IncrementalRemoteKeyedStateHandle stateHandleY = IncrementalRemoteKeyedStateHandleTest.create(new Random(2L));
        IncrementalRemoteKeyedStateHandle stateHandleZ = IncrementalRemoteKeyedStateHandleTest.create(new Random(3L));
        stateHandleX.registerSharedStates(stateRegistryA, 0L);
        stateHandleY.registerSharedStates(stateRegistryA, 0L);
        stateHandleZ.registerSharedStates(stateRegistryA, 0L);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> stateHandleX.registerSharedStates(stateRegistryA, 0L)).withFailMessage("Should not be able to register twice with the same registry.", new Object[0])).isInstanceOf(IllegalStateException.class);
        stateHandleZ.discardState();
        ((StreamStateHandle)Mockito.verify((Object)stateHandleZ.getMetaDataStateHandle(), (VerificationMode)Mockito.times((int)1))).discardState();
        stateRegistryA.close();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IncrementalRemoteKeyedStateHandleTest.create(new Random(4L)).registerSharedStates(stateRegistryA, 0L)).withFailMessage("Should not be able to register new state to closed registry.", new Object[0])).isInstanceOf(IllegalStateException.class);
        stateHandleY.discardState();
        ((StreamStateHandle)Mockito.verify((Object)stateHandleY.getMetaDataStateHandle(), (VerificationMode)Mockito.times((int)1))).discardState();
        ((StreamStateHandle)Mockito.verify((Object)stateHandleX.getMetaDataStateHandle(), (VerificationMode)Mockito.never())).discardState();
        SharedStateRegistry sharedStateRegistryB = (SharedStateRegistry)Mockito.spy((Object)new SharedStateRegistryImpl());
        stateHandleX.registerSharedStates(sharedStateRegistryB, 0L);
        stateHandleX.discardState();
        ((StreamStateHandle)Mockito.verify((Object)stateHandleX.getMetaDataStateHandle(), (VerificationMode)Mockito.times((int)1))).discardState();
        sharedStateRegistryB.unregisterUnusedState(1L);
        for (IncrementalKeyedStateHandle.HandleAndLocalPath handleAndLocalPath : stateHandleX.getSharedState()) {
            DiscardRecordedStateObject.verifyDiscard((StateObject)handleAndLocalPath.getHandle(), TernaryBoolean.TRUE);
        }
        for (IncrementalKeyedStateHandle.HandleAndLocalPath handleAndLocalPath : stateHandleY.getSharedState()) {
            DiscardRecordedStateObject.verifyDiscard((StateObject)handleAndLocalPath.getHandle(), TernaryBoolean.FALSE);
        }
        for (IncrementalKeyedStateHandle.HandleAndLocalPath handleAndLocalPath : stateHandleZ.getSharedState()) {
            DiscardRecordedStateObject.verifyDiscard((StateObject)handleAndLocalPath.getHandle(), TernaryBoolean.FALSE);
        }
        sharedStateRegistryB.close();
    }

    @Test
    void testCheckpointedSize() {
        IncrementalRemoteKeyedStateHandle stateHandle1 = IncrementalRemoteKeyedStateHandleTest.create(ThreadLocalRandom.current());
        Assertions.assertThat((long)stateHandle1.getCheckpointedSize()).isEqualTo(stateHandle1.getStateSize());
        long checkpointedSize = 123L;
        IncrementalRemoteKeyedStateHandle stateHandle2 = IncrementalRemoteKeyedStateHandleTest.create(ThreadLocalRandom.current(), checkpointedSize);
        Assertions.assertThat((long)stateHandle2.getCheckpointedSize()).isEqualTo(checkpointedSize);
    }

    @Test
    void testNonEmptyIntersection() {
        IncrementalRemoteKeyedStateHandle handle = IncrementalRemoteKeyedStateHandleTest.create(ThreadLocalRandom.current());
        KeyGroupRange expectedRange = new KeyGroupRange(0, 3);
        KeyedStateHandle newHandle = handle.getIntersection(expectedRange);
        Assertions.assertThat((Object)newHandle).isInstanceOf(IncrementalRemoteKeyedStateHandle.class);
        Assertions.assertThat((Object)newHandle.getStateHandleId()).isEqualTo((Object)handle.getStateHandleId());
    }

    @Test
    void testCollectSizeStats() {
        final IncrementalRemoteKeyedStateHandle handle = IncrementalRemoteKeyedStateHandleTest.create(ThreadLocalRandom.current());
        StateObject.StateObjectSizeStatsCollector statsCollector = StateObject.StateObjectSizeStatsCollector.create();
        handle.collectSizeStats(statsCollector);
        org.junit.jupiter.api.Assertions.assertEquals((Object)new HashMap<StateObject.StateObjectLocation, Long>(){
            {
                this.put(StateObject.StateObjectLocation.LOCAL_MEMORY, handle.getStateSize());
            }
        }, (Object)statsCollector.getStats());
    }

    @Test
    void testConcurrentCheckpointSharedStateRegistration() throws Exception {
        String localPath = "1.sst";
        ByteStreamStateHandle streamHandle1 = new ByteStreamStateHandle("file-1", new byte[]{115});
        ByteStreamStateHandle streamHandle2 = new ByteStreamStateHandle("file-2", new byte[]{115});
        SharedStateRegistryImpl registry = new SharedStateRegistryImpl();
        UUID backendID = UUID.randomUUID();
        IncrementalRemoteKeyedStateHandle handle1 = new IncrementalRemoteKeyedStateHandle(backendID, KeyGroupRange.of((int)0, (int)0), 1L, IncrementalRemoteKeyedStateHandleTest.placeSpies(Collections.singletonList(IncrementalKeyedStateHandle.HandleAndLocalPath.of((StreamStateHandle)streamHandle1, (String)localPath))), Collections.emptyList(), (StreamStateHandle)new ByteStreamStateHandle("", new byte[]{115}));
        handle1.registerSharedStates((SharedStateRegistry)registry, handle1.getCheckpointId());
        IncrementalRemoteKeyedStateHandle handle2 = new IncrementalRemoteKeyedStateHandle(backendID, KeyGroupRange.of((int)0, (int)0), 2L, IncrementalRemoteKeyedStateHandleTest.placeSpies(Collections.singletonList(IncrementalKeyedStateHandle.HandleAndLocalPath.of((StreamStateHandle)streamHandle2, (String)localPath))), Collections.emptyList(), (StreamStateHandle)new ByteStreamStateHandle("", new byte[]{115}));
        handle2.registerSharedStates((SharedStateRegistry)registry, handle2.getCheckpointId());
        registry.checkpointCompleted(1L);
        handle2.discardState();
        for (IncrementalKeyedStateHandle.HandleAndLocalPath handleAndLocalPath : handle1.getSharedState()) {
            ((StreamStateHandle)Mockito.verify((Object)handleAndLocalPath.getHandle(), (VerificationMode)Mockito.never())).discardState();
        }
        for (IncrementalKeyedStateHandle.HandleAndLocalPath handleAndLocalPath : handle2.getSharedState()) {
            ((StreamStateHandle)Mockito.verify((Object)handleAndLocalPath.getHandle(), (VerificationMode)Mockito.never())).discardState();
        }
        registry.close();
    }

    private static IncrementalRemoteKeyedStateHandle create(Random rnd) {
        return new IncrementalRemoteKeyedStateHandle(UUID.nameUUIDFromBytes("test".getBytes(StandardCharsets.UTF_8)), KeyGroupRange.of((int)0, (int)0), 1L, CheckpointTestUtils.createRandomHandleAndLocalPathList(rnd), IncrementalRemoteKeyedStateHandleTest.placeSpies(CheckpointTestUtils.createRandomHandleAndLocalPathList(rnd)), (StreamStateHandle)Mockito.spy((Object)CheckpointTestUtils.createDummyStreamStateHandle(rnd, null)));
    }

    private static IncrementalRemoteKeyedStateHandle create(Random rnd, long checkpointedSize) {
        return new IncrementalRemoteKeyedStateHandle(UUID.nameUUIDFromBytes("test".getBytes()), KeyGroupRange.of((int)0, (int)0), 1L, CheckpointTestUtils.createRandomHandleAndLocalPathList(rnd), IncrementalRemoteKeyedStateHandleTest.placeSpies(CheckpointTestUtils.createRandomHandleAndLocalPathList(rnd)), (StreamStateHandle)Mockito.spy((Object)CheckpointTestUtils.createDummyStreamStateHandle(rnd, null)), checkpointedSize);
    }

    private static List<IncrementalKeyedStateHandle.HandleAndLocalPath> placeSpies(List<IncrementalKeyedStateHandle.HandleAndLocalPath> list) {
        return list.stream().map(e -> IncrementalKeyedStateHandle.HandleAndLocalPath.of((StreamStateHandle)((StreamStateHandle)Mockito.spy((Object)e.getHandle())), (String)e.getLocalPath())).collect(Collectors.toList());
    }
}

