/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.util.function.Consumer;
import org.apache.flink.util.Preconditions;
import org.assertj.core.api.Assertions;

public class StateValidator<T> {
    private Runnable trap = () -> {};
    private Consumer<T> consumer;
    private final String stateName;

    public StateValidator(String stateName) {
        this.stateName = stateName;
        this.expectNoStateTransition();
    }

    public void expectInput(Consumer<T> asserter) {
        this.consumer = (Consumer)Preconditions.checkNotNull(asserter);
        this.trap = () -> {
            throw new AssertionError((Object)("No transition to " + this.stateName));
        };
    }

    public void validateInput(T input) {
        this.trap = () -> {};
        this.consumer.accept(input);
        this.expectNoStateTransition();
    }

    public void close() {
        this.trap.run();
    }

    public final void expectNoStateTransition() {
        this.consumer = T -> Assertions.fail((String)("No consumer has been set for " + this.stateName + ". Unexpected state transition (duplicate?)"));
    }
}

