/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.DefaultVertexParallelismStore;
import org.apache.flink.runtime.scheduler.VertexParallelismInformation;
import org.apache.flink.runtime.scheduler.VertexParallelismStore;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DefaultVertexParallelismStoreTest {
    DefaultVertexParallelismStoreTest() {
    }

    @Test
    void testNotSet() {
        DefaultVertexParallelismStore store = new DefaultVertexParallelismStore();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> store.getParallelismInfo(new JobVertexID())).withFailMessage("No parallelism information set for vertex", new Object[0])).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testSetInfo() {
        JobVertexID id = new JobVertexID();
        MockVertexParallelismInfo info = new MockVertexParallelismInfo();
        DefaultVertexParallelismStore store = new DefaultVertexParallelismStore();
        store.setParallelismInfo(id, (VertexParallelismInformation)info);
        VertexParallelismInformation storedInfo = store.getParallelismInfo(id);
        Assertions.assertThat((Object)storedInfo).isEqualTo((Object)info);
    }

    @Test
    void testGetAllInfos() {
        JobVertexID id = new JobVertexID();
        JobVertexID id2 = new JobVertexID();
        MockVertexParallelismInfo info = new MockVertexParallelismInfo();
        MockVertexParallelismInfo info2 = new MockVertexParallelismInfo();
        DefaultVertexParallelismStore store = new DefaultVertexParallelismStore();
        store.setParallelismInfo(id, (VertexParallelismInformation)info);
        store.setParallelismInfo(id2, (VertexParallelismInformation)info2);
        Assertions.assertThat((Object)store.getParallelismInfo(id)).isEqualTo((Object)info);
        Assertions.assertThat((Object)store.getParallelismInfo(id2)).isEqualTo((Object)info2);
    }

    @Test
    void testMergeParallelismStore() {
        JobVertexID id = new JobVertexID();
        JobVertexID id2 = new JobVertexID();
        MockVertexParallelismInfo info = new MockVertexParallelismInfo();
        MockVertexParallelismInfo info2 = new MockVertexParallelismInfo();
        DefaultVertexParallelismStore store = new DefaultVertexParallelismStore();
        DefaultVertexParallelismStore store2 = new DefaultVertexParallelismStore();
        store.setParallelismInfo(id, (VertexParallelismInformation)info);
        store2.setParallelismInfo(id2, (VertexParallelismInformation)info2);
        Assertions.assertThat((Object)store.getParallelismInfo(id)).isEqualTo((Object)info);
        Assertions.assertThatThrownBy(() -> store.getParallelismInfo(id2)).isInstanceOf(IllegalStateException.class);
        store.mergeParallelismStore((VertexParallelismStore)store2);
        Assertions.assertThat((Object)store.getParallelismInfo(id)).isEqualTo((Object)info);
        Assertions.assertThat((Object)store.getParallelismInfo(id2)).isEqualTo((Object)info2);
    }

    private static final class MockVertexParallelismInfo
    implements VertexParallelismInformation {
        private MockVertexParallelismInfo() {
        }

        public int getMinParallelism() {
            return 0;
        }

        public int getParallelism() {
            return 0;
        }

        public int getMaxParallelism() {
            return 0;
        }

        public void setParallelism(int parallelism) {
        }

        public void setMaxParallelism(int maxParallelism) {
        }

        public boolean canRescaleMaxParallelism(int desiredMaxParallelism) {
            return false;
        }
    }
}

