/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.metrics.NoOpMetricRegistry;
import org.apache.flink.runtime.metrics.groups.TaskManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TaskManagerMetricGroupTest {
    private static final JobID JOB_ID = new JobID();
    private static final String JOB_NAME = "test job";
    private TaskManagerMetricGroup metricGroup;

    TaskManagerMetricGroupTest() {
    }

    @BeforeEach
    void before() {
        this.metricGroup = new TaskManagerMetricGroup(NoOpMetricRegistry.INSTANCE, "testHost", "testTm");
    }

    @AfterEach
    void after() {
        if (!this.metricGroup.isClosed()) {
            this.metricGroup.close();
        }
    }

    @Test
    void testGetSameJob() {
        Assertions.assertThat((Object)this.metricGroup.addJob(JOB_ID, JOB_NAME)).isSameAs((Object)this.metricGroup.addJob(JOB_ID, JOB_NAME));
        Assertions.assertThat((Object)this.metricGroup.addJob(new JobID(), "another job")).isNotSameAs((Object)this.metricGroup.addJob(JOB_ID, JOB_NAME));
    }

    @Test
    void testReCreateAfterRemoval() {
        TaskManagerJobMetricGroup oldGroup = this.metricGroup.addJob(JOB_ID, JOB_NAME);
        this.metricGroup.removeJobMetricsGroup(JOB_ID);
        Assertions.assertThat((Object)this.metricGroup.addJob(JOB_ID, JOB_NAME)).isNotSameAs((Object)oldGroup);
    }

    @Test
    void testCloseOnRemove() {
        TaskManagerJobMetricGroup tmJobMetricGroup = this.metricGroup.addJob(JOB_ID, JOB_NAME);
        this.metricGroup.removeJobMetricsGroup(JOB_ID);
        Assertions.assertThat((boolean)tmJobMetricGroup.isClosed()).isTrue();
    }

    @Test
    void testCloseWithoutRemoval() {
        TaskManagerJobMetricGroup jobGroup = this.metricGroup.addJob(JOB_ID, JOB_NAME);
        this.metricGroup.close();
        Assertions.assertThat((boolean)jobGroup.isClosed()).isTrue();
    }

    @Test
    void testRemoveNullJobID() {
        this.metricGroup.removeJobMetricsGroup(null);
    }

    @Test
    void testRemoveInvalidJobID() {
        this.metricGroup.removeJobMetricsGroup(JOB_ID);
    }
}

