/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.Arrays;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.Reporter;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryConfiguration;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.MetricRegistryTestUtils;
import org.apache.flink.runtime.metrics.NoOpMetricRegistry;
import org.apache.flink.runtime.metrics.ReporterSetup;
import org.apache.flink.runtime.metrics.ReporterSetupBuilder;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;
import org.apache.flink.runtime.metrics.groups.GenericMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.flink.runtime.metrics.util.DummyCharacterFilter;
import org.apache.flink.runtime.metrics.util.TestReporter;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MetricGroupTest {
    private static final MetricRegistryConfiguration defaultMetricRegistryConfiguration = MetricRegistryTestUtils.defaultMetricRegistryConfiguration();
    private MetricRegistryImpl registry;
    private final MetricRegistryImpl exceptionOnRegister = new ExceptionOnRegisterRegistry();

    @BeforeEach
    void createRegistry() {
        this.registry = new MetricRegistryImpl(defaultMetricRegistryConfiguration);
    }

    @AfterEach
    void shutdownRegistry() throws Exception {
        this.registry.closeAsync().get();
        this.registry = null;
    }

    @Test
    void sameGroupOnNameCollision() {
        GenericMetricGroup group = new GenericMetricGroup((MetricRegistry)this.registry, (AbstractMetricGroup)new DummyAbstractMetricGroup((MetricRegistry)this.registry), "somegroup");
        String groupName = "sometestname";
        MetricGroup subgroup1 = group.addGroup(groupName);
        MetricGroup subgroup2 = group.addGroup(groupName);
        Assertions.assertThat((Object)subgroup1).isSameAs((Object)subgroup2);
    }

    @Test
    void testUserDefinedVariable() {
        MetricRegistry registry = NoOpMetricRegistry.INSTANCE;
        GenericMetricGroup root = new GenericMetricGroup(registry, (AbstractMetricGroup)new DummyAbstractMetricGroup(registry), "root");
        String key = "key";
        String value = "value";
        MetricGroup group = root.addGroup(key, value);
        String variableValue = (String)group.getAllVariables().get(ScopeFormat.asVariable((String)"key"));
        Assertions.assertThat((String)variableValue).isEqualTo(value);
        String identifier = group.getMetricIdentifier("metric");
        ((AbstractStringAssert)Assertions.assertThat((String)identifier).withFailMessage("Key is missing from metric identifier.", new Object[0])).contains(new CharSequence[]{"key"});
        ((AbstractStringAssert)Assertions.assertThat((String)identifier).withFailMessage("Value is missing from metric identifier.", new Object[0])).contains(new CharSequence[]{"value"});
        String logicalScope = ((AbstractMetricGroup)group).getLogicalScope((CharacterFilter)new DummyCharacterFilter());
        ((AbstractStringAssert)Assertions.assertThat((String)logicalScope).withFailMessage("Key is missing from logical scope.", new Object[0])).contains(new CharSequence[]{key});
        ((AbstractStringAssert)Assertions.assertThat((String)logicalScope).withFailMessage("Value is present in logical scope.", new Object[0])).doesNotContain(new CharSequence[]{value});
    }

    @Test
    void testUserDefinedVariableOnKeyGroup() {
        MetricRegistry registry = NoOpMetricRegistry.INSTANCE;
        GenericMetricGroup root = new GenericMetricGroup(registry, (AbstractMetricGroup)new DummyAbstractMetricGroup(registry), "root");
        String key1 = "key1";
        String value1 = "value1";
        root.addGroup(key1, value1);
        String key2 = "key2";
        String value2 = "value2";
        MetricGroup group = root.addGroup(key1).addGroup(key2, value2);
        String variableValue = (String)group.getAllVariables().get("value2");
        Assertions.assertThat((String)variableValue).isNull();
        String identifier = group.getMetricIdentifier("metric");
        ((AbstractStringAssert)Assertions.assertThat((String)identifier).withFailMessage("Key1 is missing from metric identifier.", new Object[0])).contains(new CharSequence[]{"key1"});
        ((AbstractStringAssert)Assertions.assertThat((String)identifier).withFailMessage("Key2 is missing from metric identifier.", new Object[0])).contains(new CharSequence[]{"key2"});
        ((AbstractStringAssert)Assertions.assertThat((String)identifier).withFailMessage("Value2 is missing from metric identifier.", new Object[0])).contains(new CharSequence[]{"value2"});
        String logicalScope = ((AbstractMetricGroup)group).getLogicalScope((CharacterFilter)new DummyCharacterFilter());
        ((AbstractStringAssert)Assertions.assertThat((String)logicalScope).withFailMessage("Key1 is missing from logical scope.", new Object[0])).contains(new CharSequence[]{key1});
        ((AbstractStringAssert)Assertions.assertThat((String)logicalScope).withFailMessage("Key2 is missing from logical scope.", new Object[0])).contains(new CharSequence[]{key2});
        ((AbstractStringAssert)Assertions.assertThat((String)logicalScope).withFailMessage("Value2 is missing from logical scope.", new Object[0])).contains(new CharSequence[]{value2});
    }

    @Test
    void testNameCollisionForKeyAfterGenericGroup() {
        MetricRegistry registry = NoOpMetricRegistry.INSTANCE;
        GenericMetricGroup root = new GenericMetricGroup(registry, (AbstractMetricGroup)new DummyAbstractMetricGroup(registry), "root");
        String key = "key";
        String value = "value";
        root.addGroup(key);
        MetricGroup group = root.addGroup(key, value);
        String variableValue = (String)group.getAllVariables().get(ScopeFormat.asVariable((String)"key"));
        Assertions.assertThat((String)variableValue).isNull();
        String identifier = group.getMetricIdentifier("metric");
        ((AbstractStringAssert)Assertions.assertThat((String)identifier).withFailMessage("Key is missing from metric identifier.", new Object[0])).contains(new CharSequence[]{"key"});
        ((AbstractStringAssert)Assertions.assertThat((String)identifier).withFailMessage("Value is missing from metric identifier.", new Object[0])).contains(new CharSequence[]{"value"});
        String logicalScope = ((AbstractMetricGroup)group).getLogicalScope((CharacterFilter)new DummyCharacterFilter());
        ((AbstractStringAssert)Assertions.assertThat((String)logicalScope).withFailMessage("Key is missing from logical scope.", new Object[0])).contains(new CharSequence[]{key});
        ((AbstractStringAssert)Assertions.assertThat((String)logicalScope).withFailMessage("Value is missing from logical scope.", new Object[0])).contains(new CharSequence[]{value});
    }

    @Test
    void testNameCollisionForKeyAndValueAfterGenericGroup() {
        MetricRegistry registry = NoOpMetricRegistry.INSTANCE;
        GenericMetricGroup root = new GenericMetricGroup(registry, (AbstractMetricGroup)new DummyAbstractMetricGroup(registry), "root");
        String key = "key";
        String value = "value";
        root.addGroup(key).addGroup(value);
        MetricGroup group = root.addGroup(key, value);
        String variableValue = (String)group.getAllVariables().get(ScopeFormat.asVariable((String)"key"));
        Assertions.assertThat((String)variableValue).isNull();
        String identifier = group.getMetricIdentifier("metric");
        ((AbstractStringAssert)Assertions.assertThat((String)identifier).withFailMessage("Key is missing from metric identifier.", new Object[0])).contains(new CharSequence[]{"key"});
        ((AbstractStringAssert)Assertions.assertThat((String)identifier).withFailMessage("Value is missing from metric identifier.", new Object[0])).contains(new CharSequence[]{"value"});
        String logicalScope = ((AbstractMetricGroup)group).getLogicalScope((CharacterFilter)new DummyCharacterFilter());
        ((AbstractStringAssert)Assertions.assertThat((String)logicalScope).withFailMessage("Key is missing from logical scope.", new Object[0])).contains(new CharSequence[]{key});
        ((AbstractStringAssert)Assertions.assertThat((String)logicalScope).withFailMessage("Value is missing from logical scope.", new Object[0])).contains(new CharSequence[]{value});
    }

    @Test
    void testNameCollisionAfterKeyValueGroup() {
        MetricRegistry registry = NoOpMetricRegistry.INSTANCE;
        GenericMetricGroup root = new GenericMetricGroup(registry, (AbstractMetricGroup)new DummyAbstractMetricGroup(registry), "root");
        String key = "key";
        String value = "value";
        root.addGroup(key, value);
        MetricGroup group = root.addGroup(key).addGroup(value);
        String variableValue = (String)group.getAllVariables().get(ScopeFormat.asVariable((String)"key"));
        Assertions.assertThat((String)variableValue).isEqualTo(value);
        String identifier = group.getMetricIdentifier("metric");
        ((AbstractStringAssert)Assertions.assertThat((String)identifier).withFailMessage("Key is missing from metric identifier.", new Object[0])).contains(new CharSequence[]{"key"});
        ((AbstractStringAssert)Assertions.assertThat((String)identifier).withFailMessage("Value is missing from metric identifier.", new Object[0])).contains(new CharSequence[]{"value"});
        String logicalScope = ((AbstractMetricGroup)group).getLogicalScope((CharacterFilter)new DummyCharacterFilter());
        ((AbstractStringAssert)Assertions.assertThat((String)logicalScope).withFailMessage("Key is missing from logical scope.", new Object[0])).contains(new CharSequence[]{key});
        ((AbstractStringAssert)Assertions.assertThat((String)logicalScope).withFailMessage("Value is present in logical scope.", new Object[0])).doesNotContain(new CharSequence[]{value});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testLogicalScopeShouldIgnoreValueGroupName() throws Exception {
        Configuration config = new Configuration();
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration(), Arrays.asList((ReporterSetup)ReporterSetupBuilder.METRIC_SETUP_BUILDER.forReporter("test", (Reporter)new TestReporter())));
        try {
            GenericMetricGroup root = new GenericMetricGroup((MetricRegistry)registry, (AbstractMetricGroup)new DummyAbstractMetricGroup((MetricRegistry)registry), "root");
            String key = "key";
            String value = "value";
            MetricGroup group = root.addGroup(key, value);
            String logicalScope = ((AbstractMetricGroup)group).getLogicalScope((CharacterFilter)new DummyCharacterFilter(), registry.getDelimiter(), 0);
            ((AbstractStringAssert)Assertions.assertThat((String)logicalScope).withFailMessage("Key is missing from logical scope.", new Object[0])).contains(new CharSequence[]{key});
            ((AbstractStringAssert)Assertions.assertThat((String)logicalScope).withFailMessage("Value is present in logical scope.", new Object[0])).doesNotContain(new CharSequence[]{value});
        }
        finally {
            registry.closeAsync().get();
        }
    }

    @Test
    void closedGroupDoesNotRegisterMetrics() {
        GenericMetricGroup group = new GenericMetricGroup((MetricRegistry)this.exceptionOnRegister, (AbstractMetricGroup)new DummyAbstractMetricGroup((MetricRegistry)this.exceptionOnRegister), "testgroup");
        Assertions.assertThat((boolean)group.isClosed()).isFalse();
        group.close();
        Assertions.assertThat((boolean)group.isClosed()).isTrue();
        group.counter("testcounter");
        group.gauge("testgauge", (Gauge)new Gauge<Object>(){

            public Object getValue() {
                return null;
            }
        });
    }

    @Test
    void closedGroupCreatesClosedGroups() {
        GenericMetricGroup group = new GenericMetricGroup((MetricRegistry)this.exceptionOnRegister, (AbstractMetricGroup)new DummyAbstractMetricGroup((MetricRegistry)this.exceptionOnRegister), "testgroup");
        Assertions.assertThat((boolean)group.isClosed()).isFalse();
        group.close();
        Assertions.assertThat((boolean)group.isClosed()).isTrue();
        AbstractMetricGroup subgroup = (AbstractMetricGroup)group.addGroup("test subgroup");
        Assertions.assertThat((boolean)subgroup.isClosed()).isTrue();
    }

    @Test
    void addClosedGroupReturnsNewGroupInstance() {
        GenericMetricGroup mainGroup = new GenericMetricGroup((MetricRegistry)this.exceptionOnRegister, (AbstractMetricGroup)new DummyAbstractMetricGroup((MetricRegistry)this.exceptionOnRegister), "mainGroup");
        AbstractMetricGroup subGroup = (AbstractMetricGroup)mainGroup.addGroup("subGroup");
        Assertions.assertThat((boolean)subGroup.isClosed()).isFalse();
        subGroup.close();
        Assertions.assertThat((boolean)subGroup.isClosed()).isTrue();
        AbstractMetricGroup newSubGroupWithSameNameAsClosedGroup = (AbstractMetricGroup)mainGroup.addGroup("subGroup");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)newSubGroupWithSameNameAsClosedGroup.isClosed()).withFailMessage("The new subgroup should not be closed", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)subGroup.isClosed()).withFailMessage("The old sub group is not modified", new Object[0])).isTrue();
    }

    @Test
    void tolerateMetricNameCollisions() {
        String name = "abctestname";
        GenericMetricGroup group = new GenericMetricGroup((MetricRegistry)this.registry, (AbstractMetricGroup)new DummyAbstractMetricGroup((MetricRegistry)this.registry), "testgroup");
        Assertions.assertThat((Object)group.counter("abctestname")).isNotNull();
        Assertions.assertThat((Object)group.counter("abctestname")).isNotNull();
    }

    @Test
    void tolerateMetricAndGroupNameCollisions() {
        String name = "abctestname";
        GenericMetricGroup group = new GenericMetricGroup((MetricRegistry)this.registry, (AbstractMetricGroup)new DummyAbstractMetricGroup((MetricRegistry)this.registry), "testgroup");
        Assertions.assertThat((Object)group.addGroup("abctestname")).isNotNull();
        Assertions.assertThat((Object)group.counter("abctestname")).isNotNull();
    }

    @Test
    void testCreateQueryServiceMetricInfo() {
        JobID jid = new JobID();
        JobVertexID vid = new JobVertexID();
        ExecutionAttemptID eid = ExecutionGraphTestUtils.createExecutionAttemptId(vid, 4, 5);
        MetricRegistryImpl registry = new MetricRegistryImpl(defaultMetricRegistryConfiguration);
        TaskManagerMetricGroup tm = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)registry, (String)"host", (ResourceID)new ResourceID("id"));
        TaskMetricGroup task = tm.addJob(jid, "jobname").addTask(eid, "taskName");
        GenericMetricGroup userGroup1 = new GenericMetricGroup((MetricRegistry)registry, (AbstractMetricGroup)task, "hello");
        GenericMetricGroup userGroup2 = new GenericMetricGroup((MetricRegistry)registry, (AbstractMetricGroup)userGroup1, "world");
        QueryScopeInfo.TaskQueryScopeInfo info1 = (QueryScopeInfo.TaskQueryScopeInfo)userGroup1.createQueryServiceMetricInfo((CharacterFilter)new DummyCharacterFilter());
        Assertions.assertThat((String)info1.scope).isEqualTo("hello");
        Assertions.assertThat((String)info1.jobID).isEqualTo(jid.toString());
        Assertions.assertThat((String)info1.vertexID).isEqualTo(vid.toString());
        Assertions.assertThat((int)info1.subtaskIndex).isEqualTo(4);
        QueryScopeInfo.TaskQueryScopeInfo info2 = (QueryScopeInfo.TaskQueryScopeInfo)userGroup2.createQueryServiceMetricInfo((CharacterFilter)new DummyCharacterFilter());
        Assertions.assertThat((String)info2.scope).isEqualTo("hello.world");
        Assertions.assertThat((String)info2.jobID).isEqualTo(jid.toString());
        Assertions.assertThat((String)info2.vertexID).isEqualTo(vid.toString());
        Assertions.assertThat((int)info2.subtaskIndex).isEqualTo(4);
    }

    public static class DummyAbstractMetricGroup
    extends AbstractMetricGroup<DummyAbstractMetricGroup> {
        final String groupName;

        public DummyAbstractMetricGroup(MetricRegistry registry) {
            this(registry, "foo");
        }

        public DummyAbstractMetricGroup(MetricRegistry registry, String groupName) {
            super(registry, new String[0], null);
            this.groupName = groupName;
        }

        protected QueryScopeInfo createQueryServiceMetricInfo(CharacterFilter filter) {
            return null;
        }

        protected String getGroupName(CharacterFilter filter) {
            return this.groupName;
        }

        protected void addMetric(String name, Metric metric) {
        }

        public MetricGroup addGroup(String name) {
            return new DummyAbstractMetricGroup(this.registry);
        }
    }

    private static class ExceptionOnRegisterRegistry
    extends MetricRegistryImpl {
        public ExceptionOnRegisterRegistry() {
            super(defaultMetricRegistryConfiguration);
        }

        public void register(Metric metric, String name, AbstractMetricGroup<?> parent) {
            Assertions.fail((String)"Metric should never be registered");
        }

        public void unregister(Metric metric, String name, AbstractMetricGroup<?> parent) {
            Assertions.fail((String)"Metric should never be un-registered");
        }
    }
}

