/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.Collections;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.HistogramStatistics;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.Reporter;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.MetricRegistryTestUtils;
import org.apache.flink.runtime.metrics.ReporterSetup;
import org.apache.flink.runtime.metrics.ReporterSetupBuilder;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.util.TestReporter;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MetricGroupRegistrationTest {
    MetricGroupRegistrationTest() {
    }

    @Test
    void testMetricInstantiation() throws Exception {
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration(), Collections.singletonList((ReporterSetup)ReporterSetupBuilder.METRIC_SETUP_BUILDER.forReporter("test", (Reporter)new TestReporter1())));
        TaskManagerMetricGroup root = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)registry, (String)"host", (ResourceID)new ResourceID("id"));
        Counter counter = root.counter("counter");
        Assertions.assertThat((Object)TestReporter1.lastPassedMetric).isEqualTo((Object)counter);
        Assertions.assertThat((String)TestReporter1.lastPassedName).isEqualTo("counter");
        Gauge gauge = root.gauge("gauge", (Gauge)new Gauge<Object>(){

            public Object getValue() {
                return null;
            }
        });
        Assertions.assertThat((Object)TestReporter1.lastPassedMetric).isEqualTo((Object)gauge);
        Assertions.assertThat((String)TestReporter1.lastPassedName).isEqualTo("gauge");
        Histogram histogram = root.histogram("histogram", new Histogram(){

            public void update(long value) {
            }

            public long getCount() {
                return 0L;
            }

            public HistogramStatistics getStatistics() {
                return null;
            }
        });
        Assertions.assertThat((Object)TestReporter1.lastPassedMetric).isEqualTo((Object)histogram);
        Assertions.assertThat((String)TestReporter1.lastPassedName).isEqualTo("histogram");
        registry.closeAsync().get();
    }

    @Test
    void testDuplicateGroupName() throws Exception {
        Configuration config = new Configuration();
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.fromConfiguration(config));
        TaskManagerMetricGroup root = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)registry, (String)"host", (ResourceID)new ResourceID("id"));
        MetricGroup group1 = root.addGroup("group");
        MetricGroup group2 = root.addGroup("group");
        MetricGroup group3 = root.addGroup("group");
        Assertions.assertThat((group1 == group2 && group2 == group3 ? 1 : 0) != 0).isTrue();
        registry.closeAsync().get();
    }

    public static class TestReporter1
    extends TestReporter {
        public static Metric lastPassedMetric;
        public static String lastPassedName;

        @Override
        public void notifyOfAddedMetric(Metric metric, String metricName, MetricGroup group) {
            lastPassedMetric = metric;
            lastPassedName = metricName;
        }
    }
}

