/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.time.Duration;
import org.apache.flink.metrics.groups.OperatorMetricGroup;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.groups.InternalSourceSplitMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.metrics.util.TestingMetricRegistry;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.ManualClock;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class InternalSourceSplitMetricGroupTest {
    private static final MetricRegistry registry = TestingMetricRegistry.builder().build();

    InternalSourceSplitMetricGroupTest() {
    }

    InternalSourceSplitMetricGroup getMetricGroupWithClock(ManualClock clock) {
        return InternalSourceSplitMetricGroup.wrap((OperatorMetricGroup)UnregisteredMetricGroups.createUnregisteredOperatorMetricGroup(), (Clock)clock, (String)"splitId", null);
    }

    @Test
    void testClocksStartTickingAfterSplitStarted() throws InterruptedException {
        ManualClock clock = new ManualClock(System.currentTimeMillis());
        InternalSourceSplitMetricGroup metricGroup = this.getMetricGroupWithClock(clock);
        long timeBeforeSplitStart = 4L;
        clock.advanceTime(Duration.ofMillis(timeBeforeSplitStart));
        Assertions.assertThat((double)((double)(metricGroup.getAccumulatedIdleTime() + metricGroup.getAccumulatedPausedTime()) + metricGroup.getAccumulatedActiveTime())).isEqualTo(0.0);
        metricGroup.markSplitStart();
        long timeAfterSplitStart = 6L;
        clock.advanceTime(Duration.ofMillis(timeAfterSplitStart));
        Assertions.assertThat((double)((double)(metricGroup.getAccumulatedIdleTime() + metricGroup.getAccumulatedPausedTime()) + metricGroup.getAccumulatedActiveTime())).isEqualTo((double)timeAfterSplitStart);
    }

    @Test
    void testConsistencyOfTime() throws InterruptedException {
        ManualClock clock = new ManualClock(System.currentTimeMillis());
        InternalSourceSplitMetricGroup metricGroup = this.getMetricGroupWithClock(clock);
        metricGroup.markSplitStart();
        long startTime = clock.absoluteTimeMillis();
        long pausedTime = 2L;
        metricGroup.markPaused();
        clock.advanceTime(Duration.ofMillis(pausedTime));
        metricGroup.markNotPaused();
        long activeTime = 4L;
        clock.advanceTime(Duration.ofMillis(activeTime));
        long idleTime = 1000L - pausedTime - activeTime;
        metricGroup.markIdle();
        clock.advanceTime(Duration.ofMillis(idleTime));
        metricGroup.markNotIdle();
        Assertions.assertThat((long)metricGroup.getAccumulatedPausedTime()).isEqualTo(pausedTime);
        Assertions.assertThat((double)metricGroup.getAccumulatedActiveTime()).isEqualTo((double)activeTime);
        Assertions.assertThat((long)metricGroup.getAccumulatedIdleTime()).isEqualTo(idleTime);
        long totalDuration = clock.absoluteTimeMillis() - startTime;
        Assertions.assertThat((double)metricGroup.getAccumulatedPausedTime()).isEqualTo((double)totalDuration - metricGroup.getAccumulatedActiveTime() - (double)metricGroup.getAccumulatedIdleTime());
    }
}

