/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.metrics.util.TestReporter;

public class CollectingMetricsReporter
extends TestReporter {
    @Nullable
    private final CharacterFilter characterFilter;
    private final List<MetricGroupAndName> addedMetrics = new ArrayList<MetricGroupAndName>();
    private final List<MetricGroupAndName> removedMetrics = new ArrayList<MetricGroupAndName>();

    public CollectingMetricsReporter() {
        this(null);
    }

    public CollectingMetricsReporter(@Nullable CharacterFilter characterFilter) {
        this.characterFilter = characterFilter;
    }

    @Override
    public String filterCharacters(String input) {
        return this.characterFilter == null ? input : this.characterFilter.filterCharacters(input);
    }

    @Override
    public void notifyOfAddedMetric(Metric metric, String metricName, MetricGroup group) {
        this.addedMetrics.add(new MetricGroupAndName(metricName, group));
    }

    @Override
    public void notifyOfRemovedMetric(Metric metric, String metricName, MetricGroup group) {
        this.removedMetrics.add(new MetricGroupAndName(metricName, group));
    }

    public List<MetricGroupAndName> getAddedMetrics() {
        return Collections.unmodifiableList(this.addedMetrics);
    }

    public List<MetricGroupAndName> getRemovedMetrics() {
        return Collections.unmodifiableList(this.removedMetrics);
    }

    public MetricGroupAndName findAdded(String name) {
        return this.getMetricGroupAndName(name, this.addedMetrics);
    }

    MetricGroupAndName findRemoved(String name) {
        return this.getMetricGroupAndName(name, this.removedMetrics);
    }

    private MetricGroupAndName getMetricGroupAndName(String name, List<MetricGroupAndName> metricsList) {
        return metricsList.stream().filter(groupAndName -> groupAndName.name.equals(name)).findAny().get();
    }

    public static class MetricGroupAndName {
        public final String name;
        public final MetricGroup group;

        MetricGroupAndName(String name, MetricGroup group) {
            this.name = name;
            this.group = group;
        }
    }
}

