/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.iterative.concurrent;

import org.apache.flink.runtime.iterative.concurrent.SuperstepKickoffLatch;
import org.junit.Assert;
import org.junit.Test;

public class SuperstepKickoffLatchTest {
    @Test
    public void testWaitFromOne() {
        try {
            SuperstepKickoffLatch latch = new SuperstepKickoffLatch();
            Waiter w = new Waiter(latch, 2);
            Thread waiter = new Thread(w);
            waiter.setDaemon(true);
            waiter.start();
            WatchDog wd = new WatchDog(waiter, 2000L);
            wd.start();
            Thread.sleep(100L);
            latch.triggerNextSuperstep();
            wd.join();
            if (wd.getError() != null) {
                throw wd.getError();
            }
            if (w.getError() != null) {
                throw w.getError();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)("Error: " + t.getMessage()));
        }
    }

    @Test
    public void testWaitAlreadyFulfilled() {
        try {
            SuperstepKickoffLatch latch = new SuperstepKickoffLatch();
            latch.triggerNextSuperstep();
            Waiter w = new Waiter(latch, 2);
            Thread waiter = new Thread(w);
            waiter.setDaemon(true);
            waiter.start();
            WatchDog wd = new WatchDog(waiter, 2000L);
            wd.start();
            Thread.sleep(100L);
            wd.join();
            if (wd.getError() != null) {
                throw wd.getError();
            }
            if (w.getError() != null) {
                throw w.getError();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)("Error: " + t.getMessage()));
        }
    }

    @Test
    public void testWaitIncorrect() {
        try {
            SuperstepKickoffLatch latch = new SuperstepKickoffLatch();
            latch.triggerNextSuperstep();
            latch.triggerNextSuperstep();
            try {
                latch.awaitStartOfSuperstepOrTermination(2);
                Assert.fail((String)"should throw exception");
            }
            catch (IllegalStateException illegalStateException) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error: " + e.getMessage()));
        }
    }

    @Test
    public void testWaitIncorrectAsync() {
        try {
            SuperstepKickoffLatch latch = new SuperstepKickoffLatch();
            latch.triggerNextSuperstep();
            latch.triggerNextSuperstep();
            Waiter w = new Waiter(latch, 2);
            Thread waiter = new Thread(w);
            waiter.setDaemon(true);
            waiter.start();
            WatchDog wd = new WatchDog(waiter, 2000L);
            wd.start();
            Thread.sleep(100L);
            wd.join();
            if (wd.getError() != null) {
                throw wd.getError();
            }
            if (w.getError() != null) {
                if (!(w.getError() instanceof IllegalStateException)) {
                    throw new Exception("wrong exception type " + String.valueOf(w.getError()));
                }
            } else {
                Assert.fail((String)"should cause exception");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)("Error: " + t.getMessage()));
        }
    }

    @Test
    public void testWaitForTermination() {
        try {
            SuperstepKickoffLatch latch = new SuperstepKickoffLatch();
            latch.triggerNextSuperstep();
            latch.triggerNextSuperstep();
            Waiter w = new Waiter(latch, 4);
            Thread waiter = new Thread(w);
            waiter.setDaemon(true);
            waiter.start();
            WatchDog wd = new WatchDog(waiter, 2000L);
            wd.start();
            latch.signalTermination();
            wd.join();
            if (wd.getError() != null) {
                throw wd.getError();
            }
            if (w.getError() != null) {
                throw w.getError();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)("Error: " + t.getMessage()));
        }
    }

    private static class WatchDog
    extends Thread {
        private final Thread toWatch;
        private final long timeOut;
        private volatile Throwable failed;

        public WatchDog(Thread toWatch, long timeout) {
            this.setDaemon(true);
            this.setName("Watchdog");
            this.toWatch = toWatch;
            this.timeOut = timeout;
        }

        @Override
        public void run() {
            try {
                this.toWatch.join(this.timeOut);
                if (this.toWatch.isAlive()) {
                    this.failed = new Exception("timed out");
                    this.toWatch.interrupt();
                    this.toWatch.join(2000L);
                    if (this.toWatch.isAlive()) {
                        this.toWatch.stop();
                    }
                }
            }
            catch (Throwable t) {
                this.failed = t;
            }
        }

        public Throwable getError() {
            return this.failed;
        }
    }

    private static class Waiter
    implements Runnable {
        private final SuperstepKickoffLatch latch;
        private final int waitFor;
        private volatile Throwable error;

        public Waiter(SuperstepKickoffLatch latch, int waitFor) {
            this.latch = latch;
            this.waitFor = waitFor;
        }

        @Override
        public void run() {
            try {
                this.latch.awaitStartOfSuperstepOrTermination(this.waitFor);
            }
            catch (Throwable t) {
                this.error = t;
            }
        }

        public Throwable getError() {
            return this.error;
        }
    }
}

