/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.util.Map;
import java.util.Optional;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.io.network.netty.InboundChannelHandlerFactory;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.util.ReferenceCountUtil;
import org.apache.flink.util.ConfigurationException;

public class Prio0InboundChannelHandlerFactory
implements InboundChannelHandlerFactory {
    public static final ConfigOption<String> REDIRECT_FROM_URL = ConfigOptions.key((String)"test.in.redirect.from.url").stringType().defaultValue((Object)"");
    public static final ConfigOption<String> REDIRECT_TO_URL = ConfigOptions.key((String)"test.in.redirect.to.url").stringType().defaultValue((Object)"");

    public int priority() {
        return 0;
    }

    public Optional<ChannelHandler> createHandler(Configuration configuration, Map<String, String> responseHeaders) throws ConfigurationException {
        final String redirectFromUrl = (String)configuration.get(REDIRECT_FROM_URL);
        final String redirectToUrl = (String)configuration.get(REDIRECT_TO_URL);
        if (!redirectFromUrl.isEmpty() && !redirectToUrl.isEmpty()) {
            return Optional.of(new ChannelInboundHandlerAdapter(){

                public void channelRead(ChannelHandlerContext ctx, Object msg) {
                    HttpRequest httpRequest;
                    if (msg instanceof HttpRequest && (httpRequest = (HttpRequest)msg).uri().equals(redirectFromUrl)) {
                        httpRequest.setUri(redirectToUrl);
                    }
                    ctx.fireChannelRead(ReferenceCountUtil.retain((Object)msg));
                }
            });
        }
        return Optional.empty();
    }
}

