/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.flink.runtime.checkpoint.InitializationStatus;
import org.apache.flink.runtime.checkpoint.JobInitializationMetrics;
import org.apache.flink.runtime.checkpoint.JobInitializationMetricsBuilder;
import org.apache.flink.runtime.checkpoint.SubTaskInitializationMetrics;
import org.apache.flink.runtime.checkpoint.SubTaskInitializationMetricsBuilder;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.Test;

public class JobInitializationMetricsTest {
    @Test
    public void testBuildingJobInitializationMetricsFromSingleSubtask() {
        ExecutionAttemptID executionAttemptID = ExecutionAttemptID.randomId();
        JobInitializationMetricsBuilder initializationMetricsBuilder = new JobInitializationMetricsBuilder(Collections.singleton(executionAttemptID), 0L);
        Assertions.assertThat((boolean)initializationMetricsBuilder.isComplete()).isFalse();
        SubTaskInitializationMetricsBuilder subTaskInitializationMetricsBuilder = new SubTaskInitializationMetricsBuilder(0L);
        subTaskInitializationMetricsBuilder.addDurationMetric("A", 5L);
        subTaskInitializationMetricsBuilder.addDurationMetric("A", 10L);
        subTaskInitializationMetricsBuilder.addDurationMetric("B", 20L);
        SubTaskInitializationMetrics subTaskInitializationMetrics = subTaskInitializationMetricsBuilder.setStatus(InitializationStatus.COMPLETED).build();
        initializationMetricsBuilder.reportInitializationMetrics(executionAttemptID, subTaskInitializationMetrics);
        Assertions.assertThat((boolean)initializationMetricsBuilder.isComplete()).isTrue();
        JobInitializationMetrics jobInitializationMetrics = initializationMetricsBuilder.build();
        Assertions.assertThat((long)jobInitializationMetrics.getStartTs()).isEqualTo(0L);
        Assertions.assertThat((long)jobInitializationMetrics.getEndTs()).isEqualTo(subTaskInitializationMetrics.getEndTs());
        Assertions.assertThat((Comparable)jobInitializationMetrics.getStatus()).isEqualTo((Object)InitializationStatus.COMPLETED);
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)jobInitializationMetrics.getDurationMetrics()).containsOnlyKeys((Object[])new String[]{"A", "B"})).containsEntry((Object)"A", (Object)new JobInitializationMetrics.SumMaxDuration("A").addDuration(15L))).containsEntry((Object)"B", (Object)new JobInitializationMetrics.SumMaxDuration("B").addDuration(20L));
    }

    @Test
    public void testBuildingJobInitializationMetricsFromMultipleSubtasks() {
        ExecutionAttemptID firstId = ExecutionAttemptID.randomId();
        ExecutionAttemptID secondId = ExecutionAttemptID.randomId();
        ExecutionAttemptID thirdId = ExecutionAttemptID.randomId();
        JobInitializationMetricsBuilder initializationMetricsBuilder = new JobInitializationMetricsBuilder(new HashSet<ExecutionAttemptID>(Arrays.asList(firstId, secondId, thirdId)), 0L);
        Assertions.assertThat((boolean)initializationMetricsBuilder.isComplete()).isFalse();
        SubTaskInitializationMetricsBuilder subTaskInitializationMetricsBuilder1 = new SubTaskInitializationMetricsBuilder(0L);
        subTaskInitializationMetricsBuilder1.addDurationMetric("A", 5L);
        subTaskInitializationMetricsBuilder1.addDurationMetric("B", 5L);
        initializationMetricsBuilder.reportInitializationMetrics(firstId, subTaskInitializationMetricsBuilder1.setStatus(InitializationStatus.COMPLETED).build(35L));
        Assertions.assertThat((boolean)initializationMetricsBuilder.isComplete()).isFalse();
        SubTaskInitializationMetricsBuilder subTaskInitializationMetricsBuilder = new SubTaskInitializationMetricsBuilder(100L);
        subTaskInitializationMetricsBuilder.addDurationMetric("A", 1L);
        subTaskInitializationMetricsBuilder.addDurationMetric("B", 10L);
        initializationMetricsBuilder.reportInitializationMetrics(secondId, subTaskInitializationMetricsBuilder.setStatus(InitializationStatus.COMPLETED).build(140L));
        Assertions.assertThat((boolean)initializationMetricsBuilder.isComplete()).isFalse();
        initializationMetricsBuilder.reportInitializationMetrics(thirdId, new SubTaskInitializationMetricsBuilder(200L).setStatus(InitializationStatus.FAILED).build(1000L));
        Assertions.assertThat((boolean)initializationMetricsBuilder.isComplete()).isTrue();
        JobInitializationMetrics jobInitializationMetrics = initializationMetricsBuilder.build();
        Assertions.assertThat((long)jobInitializationMetrics.getStartTs()).isEqualTo(0L);
        Assertions.assertThat((long)jobInitializationMetrics.getEndTs()).isEqualTo(1000L);
        Assertions.assertThat((Comparable)jobInitializationMetrics.getStatus()).isEqualTo((Object)InitializationStatus.FAILED);
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)jobInitializationMetrics.getDurationMetrics()).containsOnlyKeys((Object[])new String[]{"A", "B"})).containsEntry((Object)"A", (Object)new JobInitializationMetrics.SumMaxDuration("A").addDuration(5L).addDuration(1L))).containsEntry((Object)"B", (Object)new JobInitializationMetrics.SumMaxDuration("B").addDuration(5L).addDuration(10L));
    }

    @Test
    public void testSumMaxDuration() throws Exception {
        JobInitializationMetrics.SumMaxDuration duration = new JobInitializationMetrics.SumMaxDuration("A");
        duration.addDuration(1L);
        Assertions.assertThat((long)duration.getSum()).isEqualTo(1L);
        Assertions.assertThat((long)duration.getMax()).isEqualTo(1L);
        duration.addDuration(5L);
        Assertions.assertThat((long)duration.getSum()).isEqualTo(6L);
        Assertions.assertThat((long)duration.getMax()).isEqualTo(5L);
        duration.addDuration(4L);
        Assertions.assertThat((long)duration.getSum()).isEqualTo(10L);
        Assertions.assertThat((long)duration.getMax()).isEqualTo(5L);
    }
}

