/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.asyncprocessing;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.runtime.asyncprocessing.EpochManager;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;

class EpochManagerTest {
    EpochManagerTest() {
    }

    @Test
    void testBasic() {
        EpochManager epochManager = new EpochManager(null);
        EpochManager.Epoch epoch1 = epochManager.onRecord();
        EpochManager.Epoch epoch2 = epochManager.onRecord();
        AssertionsForClassTypes.assertThat((Object)epoch1).isEqualTo((Object)epoch2);
        AssertionsForClassTypes.assertThat((int)epoch1.ongoingRecordCount).isEqualTo(2);
        AtomicInteger output = new AtomicInteger(0);
        epochManager.onNonRecord(null, () -> output.incrementAndGet(), EpochManager.ParallelMode.PARALLEL_BETWEEN_EPOCH);
        EpochManager.Epoch epoch3 = epochManager.onRecord();
        AssertionsForClassTypes.assertThat((Object)epoch3).isNotEqualTo((Object)epoch1);
        AssertionsForClassTypes.assertThat((int)epochManager.outputQueue.size()).isEqualTo(1);
        AssertionsForClassTypes.assertThat((Object)((EpochManager.Epoch)epochManager.outputQueue.peek()).status).isEqualTo((Object)EpochManager.EpochStatus.CLOSED);
        AssertionsForClassTypes.assertThat((int)output.get()).isEqualTo(0);
        epochManager.completeOneRecord(epoch1);
        epochManager.completeOneRecord(epoch2);
        epochManager.completeOneRecord(epoch3);
        AssertionsForClassTypes.assertThat((int)output.get()).isEqualTo(1);
        AssertionsForClassTypes.assertThat((int)epochManager.outputQueue.size()).isEqualTo(0);
        AssertionsForClassTypes.assertThat((int)epochManager.activeEpoch.ongoingRecordCount).isEqualTo(0);
        AssertionsForClassTypes.assertThat((Object)epochManager.activeEpoch.status).isEqualTo((Object)EpochManager.EpochStatus.OPEN);
        epochManager.onNonRecord(null, () -> {
            output.incrementAndGet();
            EpochManager.Epoch epoch4 = epochManager.onRecord();
            epochManager.completeOneRecord(epoch4);
        }, EpochManager.ParallelMode.PARALLEL_BETWEEN_EPOCH);
        AssertionsForClassTypes.assertThat((int)output.get()).isEqualTo(2);
    }

    @Test
    void testTwoAction() {
        EpochManager epochManager = new EpochManager(null);
        EpochManager.Epoch epoch1 = epochManager.onRecord();
        EpochManager.Epoch epoch2 = epochManager.onRecord();
        AssertionsForClassTypes.assertThat((Object)epoch1).isEqualTo((Object)epoch2);
        AssertionsForClassTypes.assertThat((int)epoch1.ongoingRecordCount).isEqualTo(2);
        AtomicInteger output = new AtomicInteger(0);
        epochManager.onNonRecord(() -> epochManager.onEpoch(epoch1), () -> output.incrementAndGet(), EpochManager.ParallelMode.PARALLEL_BETWEEN_EPOCH);
        AssertionsForClassTypes.assertThat((Object)epoch1.status).isEqualTo((Object)EpochManager.EpochStatus.CLOSED);
        AssertionsForClassTypes.assertThat((int)output.get()).isEqualTo(0);
        epochManager.completeOneRecord(epoch1);
        epochManager.completeOneRecord(epoch2);
        AssertionsForClassTypes.assertThat((Object)epoch1.status).isEqualTo((Object)EpochManager.EpochStatus.FINISHING);
        AssertionsForClassTypes.assertThat((int)output.get()).isEqualTo(0);
        epochManager.completeOneRecord(epoch1);
        AssertionsForClassTypes.assertThat((Object)epoch1.status).isEqualTo((Object)EpochManager.EpochStatus.FINISHED);
        AssertionsForClassTypes.assertThat((int)output.get()).isEqualTo(1);
    }
}

