/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph.forwardgroup;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.forwardgroup.ForwardGroup;
import org.apache.flink.util.Preconditions;

public class JobVertexForwardGroup
implements ForwardGroup<JobVertexID> {
    private int parallelism = -1;
    private int maxParallelism = -1;
    private final Set<JobVertexID> jobVertexIds = new HashSet<JobVertexID>();

    public JobVertexForwardGroup(Set<JobVertex> jobVertices) {
        Set configuredMaxParallelisms;
        Preconditions.checkNotNull(jobVertices);
        Set configuredParallelisms = jobVertices.stream().filter(jobVertex -> {
            this.jobVertexIds.add(jobVertex.getID());
            return jobVertex.getParallelism() > 0;
        }).map(JobVertex::getParallelism).collect(Collectors.toSet());
        Preconditions.checkState((configuredParallelisms.size() <= 1 ? 1 : 0) != 0);
        if (configuredParallelisms.size() == 1) {
            this.parallelism = (Integer)configuredParallelisms.iterator().next();
        }
        if (!(configuredMaxParallelisms = jobVertices.stream().map(JobVertex::getMaxParallelism).filter(val -> val > 0).collect(Collectors.toSet())).isEmpty()) {
            this.maxParallelism = (Integer)Collections.min(configuredMaxParallelisms);
            Preconditions.checkState((this.parallelism == -1 || this.maxParallelism >= this.parallelism ? 1 : 0) != 0, (Object)"There is a job vertex in the forward group whose maximum parallelism is smaller than the group's parallelism");
        }
    }

    @Override
    public void setParallelism(int parallelism) {
        Preconditions.checkState((this.parallelism == -1 ? 1 : 0) != 0);
        this.parallelism = parallelism;
    }

    @Override
    public boolean isParallelismDecided() {
        return this.parallelism > 0;
    }

    @Override
    public int getParallelism() {
        Preconditions.checkState((boolean)this.isParallelismDecided());
        return this.parallelism;
    }

    @Override
    public void setMaxParallelism(int maxParallelism) {
        Preconditions.checkState((maxParallelism == -1 || maxParallelism >= this.parallelism ? 1 : 0) != 0, (Object)"There is a job vertex in the forward group whose maximum parallelism is smaller than the group's parallelism");
        this.maxParallelism = maxParallelism;
    }

    @Override
    public boolean isMaxParallelismDecided() {
        return this.maxParallelism > 0;
    }

    @Override
    public int getMaxParallelism() {
        Preconditions.checkState((boolean)this.isMaxParallelismDecided());
        return this.maxParallelism;
    }

    @Override
    public Set<JobVertexID> getVertexIds() {
        return this.jobVertexIds;
    }

    @VisibleForTesting
    public int size() {
        return this.jobVertexIds.size();
    }
}

