/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageSubpartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.BufferAccumulator;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.HashSubpartitionBufferAccumulator;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.HashSubpartitionBufferAccumulatorContext;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemoryManager;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.TriConsumer;

public class HashBufferAccumulator
implements BufferAccumulator,
HashSubpartitionBufferAccumulatorContext {
    private final TieredStorageMemoryManager memoryManager;
    private final HashSubpartitionBufferAccumulator[] hashSubpartitionBufferAccumulators;
    @Nullable
    private TriConsumer<TieredStorageSubpartitionId, Buffer, Integer> accumulatedBufferFlusher;

    public HashBufferAccumulator(int numSubpartitions, int bufferSize, TieredStorageMemoryManager memoryManager, boolean isPartialRecordAllowed) {
        this.memoryManager = memoryManager;
        this.hashSubpartitionBufferAccumulators = new HashSubpartitionBufferAccumulator[numSubpartitions];
        for (int i = 0; i < numSubpartitions; ++i) {
            this.hashSubpartitionBufferAccumulators[i] = new HashSubpartitionBufferAccumulator(new TieredStorageSubpartitionId(i), bufferSize, this, isPartialRecordAllowed);
        }
    }

    @Override
    public void setup(TriConsumer<TieredStorageSubpartitionId, Buffer, Integer> accumulatedBufferFlusher) {
        this.accumulatedBufferFlusher = accumulatedBufferFlusher;
    }

    @Override
    public void receive(ByteBuffer record, TieredStorageSubpartitionId subpartitionId, Buffer.DataType dataType, boolean isBroadcast) throws IOException {
        this.getSubpartitionAccumulator(subpartitionId).append(record, dataType);
    }

    @Override
    public void close() {
        Arrays.stream(this.hashSubpartitionBufferAccumulators).forEach(HashSubpartitionBufferAccumulator::close);
    }

    @Override
    public BufferBuilder requestBufferBlocking() {
        return this.memoryManager.requestBufferBlocking(this);
    }

    @Override
    public void flushAccumulatedBuffers(TieredStorageSubpartitionId subpartitionId, Buffer accumulatedBuffer, int numRemainingConsecutiveBuffers) {
        ((TriConsumer)Preconditions.checkNotNull(this.accumulatedBufferFlusher)).accept((Object)subpartitionId, (Object)accumulatedBuffer, (Object)numRemainingConsecutiveBuffers);
    }

    private HashSubpartitionBufferAccumulator getSubpartitionAccumulator(TieredStorageSubpartitionId subpartitionId) {
        return this.hashSubpartitionBufferAccumulators[subpartitionId.getSubpartitionId()];
    }
}

