/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.state.AppendingState;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.operators.windowing.WindowOperator;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalWindowFunction;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;

@Internal
public class WindowOperatorFactory<K, IN, ACC, OUT, W extends Window>
extends AbstractStreamOperatorFactory<OUT>
implements OneInputStreamOperatorFactory<IN, OUT> {
    protected final WindowAssigner<? super IN, W> windowAssigner;
    protected final KeySelector<IN, K> keySelector;
    protected final Trigger<? super IN, ? super W> trigger;
    protected final StateDescriptor<? extends AppendingState<IN, ACC>, ?> windowStateDescriptor;
    protected final InternalWindowFunction<ACC, OUT, K, W> windowFunction;
    protected final TypeSerializer<K> keySerializer;
    protected final TypeSerializer<W> windowSerializer;
    protected final long allowedLateness;
    protected final OutputTag<IN> lateDataOutputTag;

    public WindowOperatorFactory(WindowAssigner<? super IN, W> windowAssigner, TypeSerializer<W> windowSerializer, KeySelector<IN, K> keySelector, TypeSerializer<K> keySerializer, StateDescriptor<? extends AppendingState<IN, ACC>, ?> windowStateDescriptor, InternalWindowFunction<ACC, OUT, K, W> windowFunction, Trigger<? super IN, ? super W> trigger, long allowedLateness, OutputTag<IN> lateDataOutputTag) {
        Preconditions.checkArgument((allowedLateness >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((windowStateDescriptor == null || windowStateDescriptor.isSerializerInitialized() ? 1 : 0) != 0, (Object)"window state serializer is not properly initialized");
        this.windowAssigner = (WindowAssigner)Preconditions.checkNotNull(windowAssigner);
        this.windowSerializer = (TypeSerializer)Preconditions.checkNotNull(windowSerializer);
        this.keySelector = (KeySelector)Preconditions.checkNotNull(keySelector);
        this.keySerializer = (TypeSerializer)Preconditions.checkNotNull(keySerializer);
        this.windowStateDescriptor = windowStateDescriptor;
        this.windowFunction = windowFunction;
        this.trigger = (Trigger)Preconditions.checkNotNull(trigger);
        this.allowedLateness = allowedLateness;
        this.lateDataOutputTag = lateDataOutputTag;
    }

    @Override
    public <T extends StreamOperator<OUT>> T createStreamOperator(StreamOperatorParameters<OUT> parameters) {
        WindowOperator<K, IN, ACC, OUT, W> operator = new WindowOperator<K, IN, ACC, OUT, W>(this.windowAssigner, this.windowSerializer, this.keySelector, this.keySerializer, this.windowStateDescriptor, this.windowFunction, this.trigger, this.allowedLateness, this.lateDataOutputTag);
        operator.setup(parameters.getContainingTask(), parameters.getStreamConfig(), parameters.getOutput());
        operator.setProcessingTimeService(parameters.getProcessingTimeService());
        return (T)operator;
    }

    @Override
    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
        return WindowOperator.class;
    }

    @VisibleForTesting
    public Trigger<? super IN, ? super W> getTrigger() {
        return this.trigger;
    }

    @VisibleForTesting
    public KeySelector<IN, K> getKeySelector() {
        return this.keySelector;
    }

    @VisibleForTesting
    public WindowAssigner<? super IN, W> getWindowAssigner() {
        return this.windowAssigner;
    }

    @VisibleForTesting
    public StateDescriptor<? extends AppendingState<IN, ACC>, ?> getStateDescriptor() {
        return this.windowStateDescriptor;
    }
}

