/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.state.v2.ValueState;
import org.apache.flink.api.common.state.v2.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.asyncprocessing.operators.AbstractAsyncStateUdfStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

@Internal
public class StreamGroupedReduceAsyncStateOperator<IN>
extends AbstractAsyncStateUdfStreamOperator<IN, ReduceFunction<IN>>
implements OneInputStreamOperator<IN, IN> {
    private static final long serialVersionUID = 1L;
    private static final String STATE_NAME = "_op_state";
    private transient ValueState<IN> values;
    private final TypeSerializer<IN> serializer;

    public StreamGroupedReduceAsyncStateOperator(ReduceFunction<IN> reducer, TypeSerializer<IN> serializer) {
        super(reducer);
        this.serializer = serializer;
    }

    @Override
    public void open() throws Exception {
        super.open();
        ValueStateDescriptor stateId = new ValueStateDescriptor(STATE_NAME, this.serializer);
        this.values = this.getRuntimeContext().getValueState(stateId);
    }

    @Override
    public void processElement(StreamRecord<IN> element) throws Exception {
        IN value = element.getValue();
        this.values.asyncValue().thenAccept(currentValue -> {
            if (currentValue != null) {
                Object reduced = ((ReduceFunction)this.userFunction).reduce(currentValue, value);
                this.values.asyncUpdate(reduced).thenAccept(e -> this.output.collect(element.replace(reduced)));
            } else {
                this.values.asyncUpdate(value).thenAccept(e -> this.output.collect(element.replace(value)));
            }
        });
    }
}

