/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.source;

import java.io.Serializable;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.functions.source.TimestampedInputSplit;
import org.apache.flink.util.Preconditions;

public class TimestampedFileInputSplit
extends FileInputSplit
implements TimestampedInputSplit {
    private static final long serialVersionUID = -8153252402661556005L;
    private final long modificationTime;
    private Serializable splitState;

    public TimestampedFileInputSplit(long modificationTime, int num, Path file, long start, long length, String[] hosts) {
        super(num, file, start, length, hosts);
        Preconditions.checkArgument((modificationTime >= 0L || modificationTime == Long.MIN_VALUE ? 1 : 0) != 0, (Object)("Invalid File Split Modification Time: " + modificationTime + "."));
        this.modificationTime = modificationTime;
    }

    @Override
    public void setSplitState(Serializable state) {
        this.splitState = state;
    }

    @Override
    public Serializable getSplitState() {
        return this.splitState;
    }

    @Override
    public long getModificationTime() {
        return this.modificationTime;
    }

    @Override
    public int compareTo(TimestampedInputSplit o) {
        TimestampedFileInputSplit other = (TimestampedFileInputSplit)o;
        int modTimeComp = Long.compare(this.modificationTime, other.modificationTime);
        if ((long)modTimeComp != 0L) {
            return modTimeComp;
        }
        if (this.getPath() == null && other.getPath() != null) {
            return 1;
        }
        if (this.getPath() != null && other.getPath() == null) {
            return -1;
        }
        int pathComp = this.getPath() == other.getPath() ? 0 : this.getPath().compareTo((Object)other.getPath());
        return pathComp != 0 ? pathComp : this.getSplitNumber() - other.getSplitNumber();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof TimestampedFileInputSplit && super.equals(o)) {
            TimestampedFileInputSplit that = (TimestampedFileInputSplit)o;
            return this.modificationTime == that.modificationTime;
        }
        return false;
    }

    public int hashCode() {
        int res = 37 * (int)(this.modificationTime ^ this.modificationTime >>> 32);
        return 37 * res + super.hashCode();
    }

    public String toString() {
        return "[" + this.getSplitNumber() + "] " + this.getPath() + " mod@ " + this.modificationTime + " : " + this.getStart() + " + " + this.getLength();
    }
}

