/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.connector.sink2;

import java.util.Objects;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.streaming.api.connector.sink2.CommittableMessage;

@Experimental
public class CommittableSummary<CommT>
implements CommittableMessage<CommT> {
    private final int subtaskId;
    private final int numberOfSubtasks;
    private final long checkpointId;
    private final int numberOfCommittables;
    @Deprecated(forRemoval=true)
    private final int numberOfPendingCommittables;
    private final int numberOfFailedCommittables;

    public CommittableSummary(int subtaskId, int numberOfSubtasks, long checkpointId, int numberOfCommittables, int numberOfFailedCommittables) {
        this(subtaskId, numberOfSubtasks, checkpointId, numberOfCommittables, 0, numberOfFailedCommittables);
    }

    @Deprecated
    public CommittableSummary(int subtaskId, int numberOfSubtasks, long checkpointId, int numberOfCommittables, int numberOfPendingCommittables, int numberOfFailedCommittables) {
        this.subtaskId = subtaskId;
        this.numberOfSubtasks = numberOfSubtasks;
        this.checkpointId = checkpointId;
        this.numberOfCommittables = numberOfCommittables;
        this.numberOfPendingCommittables = numberOfPendingCommittables;
        this.numberOfFailedCommittables = numberOfFailedCommittables;
    }

    @Override
    public int getSubtaskId() {
        return this.subtaskId;
    }

    public int getNumberOfSubtasks() {
        return this.numberOfSubtasks;
    }

    @Override
    public long getCheckpointId() {
        return this.checkpointId;
    }

    public int getNumberOfCommittables() {
        return this.numberOfCommittables;
    }

    @Deprecated
    public int getNumberOfPendingCommittables() {
        return 0;
    }

    public int getNumberOfFailedCommittables() {
        return this.numberOfFailedCommittables;
    }

    public <NewCommT> CommittableSummary<NewCommT> map() {
        return new CommittableSummary<CommT>(this.subtaskId, this.numberOfSubtasks, this.checkpointId, this.numberOfCommittables, this.numberOfFailedCommittables);
    }

    public String toString() {
        return "CommittableSummary{subtaskId=" + this.subtaskId + ", numberOfSubtasks=" + this.numberOfSubtasks + ", checkpointId=" + this.checkpointId + ", numberOfCommittables=" + this.numberOfCommittables + ", numberOfPendingCommittables=" + this.numberOfPendingCommittables + ", numberOfFailedCommittables=" + this.numberOfFailedCommittables + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommittableSummary that = (CommittableSummary)o;
        return this.subtaskId == that.subtaskId && this.numberOfSubtasks == that.numberOfSubtasks && this.checkpointId == that.checkpointId && this.numberOfCommittables == that.numberOfCommittables && this.numberOfPendingCommittables == that.numberOfPendingCommittables && this.numberOfFailedCommittables == that.numberOfFailedCommittables;
    }

    public int hashCode() {
        return Objects.hash(this.subtaskId, this.numberOfSubtasks, this.checkpointId, this.numberOfCommittables, this.numberOfPendingCommittables, this.numberOfFailedCommittables);
    }
}

