/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.v2.ttl;

import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.runtime.state.ttl.AbstractTtlDecorator;
import org.apache.flink.runtime.state.ttl.TtlTimeProvider;
import org.apache.flink.runtime.state.ttl.TtlValue;
import org.apache.flink.util.FlinkRuntimeException;

public class TtlAggregateFunction<IN, ACC, OUT>
extends AbstractTtlDecorator<AggregateFunction<IN, ACC, OUT>>
implements AggregateFunction<IN, TtlValue<ACC>, OUT> {
    public TtlAggregateFunction(AggregateFunction<IN, ACC, OUT> aggFunction, StateTtlConfig config, TtlTimeProvider timeProvider) {
        super(aggFunction, config, timeProvider);
    }

    public TtlValue<ACC> createAccumulator() {
        return this.wrapWithTs(((AggregateFunction)this.original).createAccumulator());
    }

    public TtlValue<ACC> add(IN value, TtlValue<ACC> accumulator) {
        ACC userAcc = this.getUnexpired(accumulator);
        userAcc = userAcc == null ? ((AggregateFunction)this.original).createAccumulator() : userAcc;
        return this.wrapWithTs(((AggregateFunction)this.original).add(value, userAcc));
    }

    public OUT getResult(TtlValue<ACC> accumulator) {
        ACC userAcc;
        try {
            userAcc = this.getElementWithTtlCheck(accumulator);
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Failed to retrieve original internal aggregating state", (Throwable)e);
        }
        return (OUT)(userAcc == null ? null : ((AggregateFunction)this.original).getResult(userAcc));
    }

    public TtlValue<ACC> merge(TtlValue<ACC> a, TtlValue<ACC> b) {
        ACC userA = this.getUnexpired(a);
        ACC userB = this.getUnexpired(b);
        if (userA != null && userB != null) {
            return this.wrapWithTs(((AggregateFunction)this.original).merge(userA, userB));
        }
        if (userA != null) {
            return this.rewrapWithNewTs(a);
        }
        if (userB != null) {
            return this.rewrapWithNewTs(b);
        }
        return null;
    }
}

