/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.util.Preconditions;

public class ExecutionSlotSharingGroup {
    private final Set<ExecutionVertexID> executionVertexIds;
    @Nonnull
    private final SlotSharingGroup slotSharingGroup;

    public ExecutionSlotSharingGroup(@Nonnull SlotSharingGroup slotSharingGroup) {
        this.slotSharingGroup = (SlotSharingGroup)Preconditions.checkNotNull((Object)slotSharingGroup);
        this.executionVertexIds = new HashSet<ExecutionVertexID>();
    }

    public void addVertex(ExecutionVertexID executionVertexId) {
        this.executionVertexIds.add(executionVertexId);
    }

    @Nonnull
    @VisibleForTesting
    SlotSharingGroup getSlotSharingGroup() {
        return this.slotSharingGroup;
    }

    @Nonnull
    ResourceProfile getResourceProfile() {
        return this.slotSharingGroup.getResourceProfile();
    }

    public Set<ExecutionVertexID> getExecutionVertexIds() {
        return Collections.unmodifiableSet(this.executionVertexIds);
    }

    public String toString() {
        return "ExecutionSlotSharingGroup{executionVertexIds=" + this.executionVertexIds + ", slotSharingGroup=" + this.slotSharingGroup + "}";
    }
}

