/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.dump;

public abstract class QueryScopeInfo {
    public static final byte INFO_CATEGORY_JM = 0;
    public static final byte INFO_CATEGORY_TM = 1;
    public static final byte INFO_CATEGORY_JOB = 2;
    public static final byte INFO_CATEGORY_TASK = 3;
    public static final byte INFO_CATEGORY_OPERATOR = 4;
    public static final byte INFO_CATEGORY_JM_OPERATOR = 5;
    public final String scope;

    private QueryScopeInfo(String scope) {
        this.scope = scope;
    }

    public abstract QueryScopeInfo copy(String var1);

    public abstract byte getCategory();

    public String toString() {
        return "QueryScopeInfo{scope='" + this.scope + "', category='" + this.getCategory() + "'}";
    }

    protected String concatScopes(String additionalScope) {
        return this.scope.isEmpty() ? additionalScope : this.scope + "." + additionalScope;
    }

    public static class JobManagerOperatorQueryScopeInfo
    extends QueryScopeInfo {
        public final String jobID;
        public final String vertexID;
        public final String operatorName;

        public JobManagerOperatorQueryScopeInfo(String jobID, String vertexID, String operatorName) {
            this(jobID, vertexID, operatorName, "");
        }

        public JobManagerOperatorQueryScopeInfo(String jobID, String vertexID, String operatorName, String scope) {
            super(scope);
            this.jobID = jobID;
            this.vertexID = vertexID;
            this.operatorName = operatorName;
        }

        @Override
        public JobManagerOperatorQueryScopeInfo copy(String additionalScope) {
            return new JobManagerOperatorQueryScopeInfo(this.jobID, this.vertexID, this.operatorName, this.concatScopes(additionalScope));
        }

        @Override
        public byte getCategory() {
            return 5;
        }
    }

    public static class OperatorQueryScopeInfo
    extends QueryScopeInfo {
        public final String jobID;
        public final String vertexID;
        public final int subtaskIndex;
        public final int attemptNumber;
        public final String operatorName;

        public OperatorQueryScopeInfo(String jobID, String vertexid, int subtaskIndex, int attemptNumber, String operatorName) {
            this(jobID, vertexid, subtaskIndex, attemptNumber, operatorName, "");
        }

        public OperatorQueryScopeInfo(String jobID, String vertexid, int subtaskIndex, int attemptNumber, String operatorName, String scope) {
            super(scope);
            this.jobID = jobID;
            this.vertexID = vertexid;
            this.subtaskIndex = subtaskIndex;
            this.attemptNumber = attemptNumber;
            this.operatorName = operatorName;
        }

        @Override
        public OperatorQueryScopeInfo copy(String additionalScope) {
            return new OperatorQueryScopeInfo(this.jobID, this.vertexID, this.subtaskIndex, this.attemptNumber, this.operatorName, this.concatScopes(additionalScope));
        }

        @Override
        public byte getCategory() {
            return 4;
        }
    }

    public static class TaskQueryScopeInfo
    extends QueryScopeInfo {
        public final String jobID;
        public final String vertexID;
        public final int subtaskIndex;
        public final int attemptNumber;

        public TaskQueryScopeInfo(String jobID, String vertexid, int subtaskIndex, int attemptNumber) {
            this(jobID, vertexid, subtaskIndex, attemptNumber, "");
        }

        public TaskQueryScopeInfo(String jobID, String vertexid, int subtaskIndex, int attemptNumber, String scope) {
            super(scope);
            this.jobID = jobID;
            this.vertexID = vertexid;
            this.subtaskIndex = subtaskIndex;
            this.attemptNumber = attemptNumber;
        }

        @Override
        public TaskQueryScopeInfo copy(String additionalScope) {
            return new TaskQueryScopeInfo(this.jobID, this.vertexID, this.subtaskIndex, this.attemptNumber, this.concatScopes(additionalScope));
        }

        @Override
        public byte getCategory() {
            return 3;
        }
    }

    public static class JobQueryScopeInfo
    extends QueryScopeInfo {
        public final String jobID;

        public JobQueryScopeInfo(String jobID) {
            this(jobID, "");
        }

        public JobQueryScopeInfo(String jobID, String scope) {
            super(scope);
            this.jobID = jobID;
        }

        @Override
        public JobQueryScopeInfo copy(String additionalScope) {
            return new JobQueryScopeInfo(this.jobID, this.concatScopes(additionalScope));
        }

        @Override
        public byte getCategory() {
            return 2;
        }
    }

    public static class TaskManagerQueryScopeInfo
    extends QueryScopeInfo {
        public final String taskManagerID;

        public TaskManagerQueryScopeInfo(String taskManagerId) {
            this(taskManagerId, "");
        }

        public TaskManagerQueryScopeInfo(String taskManagerId, String scope) {
            super(scope);
            this.taskManagerID = taskManagerId;
        }

        @Override
        public TaskManagerQueryScopeInfo copy(String additionalScope) {
            return new TaskManagerQueryScopeInfo(this.taskManagerID, this.concatScopes(additionalScope));
        }

        @Override
        public byte getCategory() {
            return 1;
        }
    }

    public static class JobManagerQueryScopeInfo
    extends QueryScopeInfo {
        public JobManagerQueryScopeInfo() {
            super("");
        }

        public JobManagerQueryScopeInfo(String scope) {
            super(scope);
        }

        @Override
        public JobManagerQueryScopeInfo copy(String additionalScope) {
            return new JobManagerQueryScopeInfo(this.concatScopes(additionalScope));
        }

        @Override
        public byte getCategory() {
            return 0;
        }
    }
}

