/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.messages.webmonitor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.messages.webmonitor.InfoMessage;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.messages.json.JobIDDeserializer;
import org.apache.flink.runtime.rest.messages.json.JobIDSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.util.Preconditions;

public class JobIdsWithStatusOverview
implements ResponseBody,
InfoMessage {
    private static final long serialVersionUID = -3699051943490133183L;
    public static final String FIELD_NAME_JOBS = "jobs";
    @JsonProperty(value="jobs")
    private final Collection<JobIdWithStatus> jobsWithStatus;

    @JsonCreator
    public JobIdsWithStatusOverview(@JsonProperty(value="jobs") Collection<JobIdWithStatus> jobsWithStatus) {
        this.jobsWithStatus = (Collection)Preconditions.checkNotNull(jobsWithStatus);
    }

    public JobIdsWithStatusOverview(JobIdsWithStatusOverview first, JobIdsWithStatusOverview second) {
        this.jobsWithStatus = JobIdsWithStatusOverview.combine(first.getJobsWithStatus(), second.getJobsWithStatus());
    }

    public Collection<JobIdWithStatus> getJobsWithStatus() {
        return this.jobsWithStatus;
    }

    public int hashCode() {
        return this.jobsWithStatus.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JobIdsWithStatusOverview) {
            JobIdsWithStatusOverview that = (JobIdsWithStatusOverview)obj;
            return this.jobsWithStatus.equals(that.getJobsWithStatus());
        }
        return false;
    }

    public String toString() {
        return "JobIdsWithStatusesOverview { " + this.jobsWithStatus + " }";
    }

    private static Collection<JobIdWithStatus> combine(Collection<JobIdWithStatus> first, Collection<JobIdWithStatus> second) {
        Preconditions.checkNotNull(first);
        Preconditions.checkNotNull(second);
        ArrayList<JobIdWithStatus> result = new ArrayList<JobIdWithStatus>(first.size() + second.size());
        result.addAll(first);
        result.addAll(second);
        return result;
    }

    public static final class JobIdWithStatus
    implements Serializable {
        private static final long serialVersionUID = -499449819268733026L;
        public static final String FIELD_NAME_JOB_ID = "id";
        public static final String FIELD_NAME_JOB_STATUS = "status";
        @JsonProperty(value="id")
        @JsonSerialize(using=JobIDSerializer.class)
        private final JobID jobId;
        @JsonProperty(value="status")
        private final JobStatus jobStatus;

        @JsonCreator
        public JobIdWithStatus(@JsonProperty(value="id") @JsonDeserialize(using=JobIDDeserializer.class) JobID jobId, @JsonProperty(value="status") JobStatus jobStatus) {
            this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId);
            this.jobStatus = (JobStatus)Preconditions.checkNotNull((Object)jobStatus);
        }

        public JobID getJobId() {
            return this.jobId;
        }

        public JobStatus getJobStatus() {
            return this.jobStatus;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JobIdWithStatus that = (JobIdWithStatus)o;
            return Objects.equals(this.jobId, that.jobId) && this.jobStatus == that.jobStatus;
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.jobStatus);
        }
    }
}

