/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.shuffle.EmptyTieredShuffleMasterSnapshot;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.shuffle.TieredShuffleMasterSnapshot;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierShuffleDescriptor;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierShuffleHandler;
import org.apache.flink.runtime.shuffle.ShuffleMasterSnapshotContext;
import org.apache.flink.runtime.shuffle.ShuffleMetrics;

public interface TierMasterAgent {
    public void registerJob(JobID var1, TierShuffleHandler var2);

    public void unregisterJob(JobID var1);

    public TierShuffleDescriptor addPartitionAndGetShuffleDescriptor(JobID var1, int var2, ResultPartitionID var3);

    default public void snapshotState(CompletableFuture<TieredShuffleMasterSnapshot> snapshotFuture, ShuffleMasterSnapshotContext context, JobID jobId) {
        snapshotFuture.complete(EmptyTieredShuffleMasterSnapshot.getInstance());
    }

    default public void snapshotState(CompletableFuture<TieredShuffleMasterSnapshot> snapshotFuture) {
        snapshotFuture.complete(EmptyTieredShuffleMasterSnapshot.getInstance());
    }

    default public void restoreState(TieredShuffleMasterSnapshot snapshot, JobID jobId) {
    }

    default public void restoreState(TieredShuffleMasterSnapshot snapshot) {
    }

    default public CompletableFuture<Map<ResultPartitionID, ShuffleMetrics>> getPartitionWithMetrics(JobID jobId, Duration timeout, Set<ResultPartitionID> expectedPartitions) {
        if (!this.partitionInRemote()) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        throw new UnsupportedOperationException("remote partition should be reported by tier itself.");
    }

    public void releasePartition(TierShuffleDescriptor var1);

    public void close();

    default public boolean partitionInRemote() {
        return false;
    }
}

