/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.filemerging;

import net.jcip.annotations.ThreadSafe;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.checkpoint.filemerging.FileMergingSnapshotManager;
import org.apache.flink.runtime.metrics.groups.ProxyMetricGroup;

@ThreadSafe
public class FileMergingMetricGroup
extends ProxyMetricGroup<MetricGroup> {
    private static final String PREFIX = "fileMerging";
    @VisibleForTesting
    public static final String LOGICAL_FILE_COUNT = "fileMerging.logicalFileCount";
    @VisibleForTesting
    public static final String LOGICAL_FILE_SIZE = "fileMerging.logicalFileSize";
    @VisibleForTesting
    public static final String PHYSICAL_FILE_COUNT = "fileMerging.physicalFileCount";
    @VisibleForTesting
    public static final String PHYSICAL_FILE_SIZE = "fileMerging.physicalFileSize";

    public FileMergingMetricGroup(MetricGroup parentMetricGroup, FileMergingSnapshotManager.SpaceStat spaceStat) {
        super(parentMetricGroup);
        this.registerMetrics(spaceStat);
    }

    public void registerMetrics(FileMergingSnapshotManager.SpaceStat spaceStat) {
        this.gauge(LOGICAL_FILE_COUNT, spaceStat.logicalFileCount::get);
        this.gauge(LOGICAL_FILE_SIZE, spaceStat.logicalFileSize::get);
        this.gauge(PHYSICAL_FILE_COUNT, spaceStat.physicalFileCount::get);
        this.gauge(PHYSICAL_FILE_SIZE, spaceStat.physicalFileSize::get);
    }
}

