/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util.typeutils;

import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.util.typeutils.FieldAccessor;
import org.apache.flink.streaming.util.typeutils.FieldAccessorFactory;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class FieldAccessorTest {
    FieldAccessorTest() {
    }

    @Test
    void testFlatTuple() {
        Tuple2 t = Tuple2.of((Object)"aa", (Object)5);
        TupleTypeInfo tpeInfo = (TupleTypeInfo)TypeExtractor.getForObject((Object)t);
        FieldAccessor f0 = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"f0", null);
        Assertions.assertThat((Class)f0.getFieldType().getTypeClass()).isEqualTo(String.class);
        Assertions.assertThat((String)((String)f0.get((Object)t))).isEqualTo("aa");
        Assertions.assertThat((String)((String)t.f0)).isEqualTo("aa");
        t = (Tuple2)f0.set((Object)t, (Object)"b");
        Assertions.assertThat((String)((String)f0.get((Object)t))).isEqualTo("b");
        Assertions.assertThat((String)((String)t.f0)).isEqualTo("b");
        FieldAccessor f1 = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"f1", null);
        Assertions.assertThat((Class)f1.getFieldType().getTypeClass()).isEqualTo(Integer.class);
        Assertions.assertThat((Integer)((Integer)f1.get((Object)t))).isEqualTo(5);
        Assertions.assertThat((Integer)((Integer)t.f1)).isEqualTo(5);
        t = (Tuple2)f1.set((Object)t, (Object)7);
        Assertions.assertThat((Integer)((Integer)f1.get((Object)t))).isEqualTo(7);
        Assertions.assertThat((Integer)((Integer)t.f1)).isEqualTo(7);
        Assertions.assertThat((String)((String)f0.get((Object)t))).isEqualTo("b");
        Assertions.assertThat((String)((String)t.f0)).isEqualTo("b");
        FieldAccessor f1n = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (int)1, null);
        Assertions.assertThat((Class)f1n.getFieldType().getTypeClass()).isEqualTo(Integer.class);
        Assertions.assertThat((Integer)((Integer)f1n.get((Object)t))).isEqualTo(7);
        Assertions.assertThat((Integer)((Integer)t.f1)).isEqualTo(7);
        t = (Tuple2)f1n.set((Object)t, (Object)10);
        Assertions.assertThat((Integer)((Integer)f1n.get((Object)t))).isEqualTo(10);
        Assertions.assertThat((Integer)((Integer)f1.get((Object)t))).isEqualTo(10);
        Assertions.assertThat((Integer)((Integer)t.f1)).isEqualTo(10);
        Assertions.assertThat((String)((String)f0.get((Object)t))).isEqualTo("b");
        Assertions.assertThat((String)((String)t.f0)).isEqualTo("b");
        FieldAccessor f1ns = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"1", null);
        Assertions.assertThat((Class)f1ns.getFieldType().getTypeClass()).isEqualTo(Integer.class);
        Assertions.assertThat((Integer)((Integer)f1ns.get((Object)t))).isEqualTo(10);
        Assertions.assertThat((Integer)((Integer)t.f1)).isEqualTo(10);
        t = (Tuple2)f1ns.set((Object)t, (Object)11);
        Assertions.assertThat((Integer)((Integer)f1ns.get((Object)t))).isEqualTo(11);
        Assertions.assertThat((Integer)((Integer)f1.get((Object)t))).isEqualTo(11);
        Assertions.assertThat((Integer)((Integer)t.f1)).isEqualTo(11);
        Assertions.assertThat((String)((String)f0.get((Object)t))).isEqualTo("b");
        Assertions.assertThat((String)((String)t.f0)).isEqualTo("b");
        FieldAccessor f0f0 = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"f0.0", null);
        Assertions.assertThat((Class)f0f0.getFieldType().getTypeClass()).isEqualTo(String.class);
        Assertions.assertThat((String)((String)f0f0.get((Object)t))).isEqualTo("b");
        Assertions.assertThat((String)((String)t.f0)).isEqualTo("b");
        t = (Tuple2)f0f0.set((Object)t, (Object)"cc");
        Assertions.assertThat((String)((String)f0f0.get((Object)t))).isEqualTo("cc");
        Assertions.assertThat((String)((String)t.f0)).isEqualTo("cc");
    }

    @Test
    void testIllegalFlatTuple() {
        Tuple2 t = Tuple2.of((Object)"aa", (Object)5);
        TupleTypeInfo tpeInfo = (TupleTypeInfo)TypeExtractor.getForObject((Object)t);
        Assertions.assertThatThrownBy(() -> FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"illegal", null)).isInstanceOf(CompositeType.InvalidFieldReferenceException.class);
    }

    @Test
    void testTupleInTuple() {
        Tuple2 t = Tuple2.of((Object)"aa", (Object)Tuple3.of((Object)5, (Object)9L, (Object)2.0));
        TupleTypeInfo tpeInfo = (TupleTypeInfo)TypeExtractor.getForObject((Object)t);
        FieldAccessor f0 = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"f0", null);
        Assertions.assertThat((Class)f0.getFieldType().getTypeClass()).isEqualTo(String.class);
        Assertions.assertThat((String)((String)f0.get((Object)t))).isEqualTo("aa");
        Assertions.assertThat((String)((String)t.f0)).isEqualTo("aa");
        FieldAccessor f1f2 = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"f1.f2", null);
        Assertions.assertThat((Class)f1f2.getFieldType().getTypeClass()).isEqualTo(Double.class);
        Assertions.assertThat((Double)((Double)f1f2.get((Object)t))).isEqualTo(2.0);
        Assertions.assertThat((Double)((Double)((Tuple3)t.f1).f2)).isEqualTo(2.0);
        t = (Tuple2)f1f2.set((Object)t, (Object)3.0);
        Assertions.assertThat((Double)((Double)f1f2.get((Object)t))).isEqualTo(3.0);
        Assertions.assertThat((Double)((Double)((Tuple3)t.f1).f2)).isEqualTo(3.0);
        Assertions.assertThat((String)((String)f0.get((Object)t))).isEqualTo("aa");
        Assertions.assertThat((String)((String)t.f0)).isEqualTo("aa");
        FieldAccessor f1 = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"f1", null);
        Assertions.assertThat((Class)f1.getFieldType().getTypeClass()).isEqualTo(Tuple3.class);
        Assertions.assertThat((Object)((Tuple3)f1.get((Object)t))).isEqualTo((Object)Tuple3.of((Object)5, (Object)9L, (Object)3.0));
        Assertions.assertThat((Object)((Tuple3)t.f1)).isEqualTo((Object)Tuple3.of((Object)5, (Object)9L, (Object)3.0));
        t = (Tuple2)f1.set((Object)t, (Object)Tuple3.of((Object)8, (Object)12L, (Object)4.0));
        Assertions.assertThat((Object)((Tuple3)f1.get((Object)t))).isEqualTo((Object)Tuple3.of((Object)8, (Object)12L, (Object)4.0));
        Assertions.assertThat((Object)((Tuple3)t.f1)).isEqualTo((Object)Tuple3.of((Object)8, (Object)12L, (Object)4.0));
        Assertions.assertThat((String)((String)f0.get((Object)t))).isEqualTo("aa");
        Assertions.assertThat((String)((String)t.f0)).isEqualTo("aa");
        FieldAccessor f1n = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (int)1, null);
        Assertions.assertThat((Class)f1n.getFieldType().getTypeClass()).isEqualTo(Tuple3.class);
        Assertions.assertThat((Object)((Tuple3)f1n.get((Object)t))).isEqualTo((Object)Tuple3.of((Object)8, (Object)12L, (Object)4.0));
        Assertions.assertThat((Object)((Tuple3)t.f1)).isEqualTo((Object)Tuple3.of((Object)8, (Object)12L, (Object)4.0));
        t = (Tuple2)f1n.set((Object)t, (Object)Tuple3.of((Object)10, (Object)13L, (Object)5.0));
        Assertions.assertThat((Object)((Tuple3)f1n.get((Object)t))).isEqualTo((Object)Tuple3.of((Object)10, (Object)13L, (Object)5.0));
        Assertions.assertThat((Object)((Tuple3)f1.get((Object)t))).isEqualTo((Object)Tuple3.of((Object)10, (Object)13L, (Object)5.0));
        Assertions.assertThat((Object)((Tuple3)t.f1)).isEqualTo((Object)Tuple3.of((Object)10, (Object)13L, (Object)5.0));
        Assertions.assertThat((String)((String)f0.get((Object)t))).isEqualTo("aa");
        Assertions.assertThat((String)((String)t.f0)).isEqualTo("aa");
    }

    @Test
    void testIllegalTupleField() {
        Assertions.assertThatThrownBy(() -> FieldAccessorFactory.getAccessor((TypeInformation)TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{Integer.class, Integer.class}), (int)2, null)).isInstanceOf(CompositeType.InvalidFieldReferenceException.class);
    }

    @Test
    void testTupleInPojoInTuple() {
        Tuple2 t = Tuple2.of((Object)"aa", (Object)new Foo(8, (Tuple2<String, Long>)Tuple2.of((Object)"ddd", (Object)9L), (short)2));
        TupleTypeInfo tpeInfo = (TupleTypeInfo)TypeExtractor.getForObject((Object)t);
        FieldAccessor f1tf1 = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"f1.t.f1", null);
        Assertions.assertThat((Class)f1tf1.getFieldType().getTypeClass()).isEqualTo(Long.class);
        Assertions.assertThat((Long)((Long)f1tf1.get((Object)t))).isEqualTo(9L);
        Assertions.assertThat((Long)((Long)((Foo)t.f1).t.f1)).isEqualTo(9L);
        t = (Tuple2)f1tf1.set((Object)t, (Object)12L);
        Assertions.assertThat((Long)((Long)f1tf1.get((Object)t))).isEqualTo(12L);
        Assertions.assertThat((Long)((Long)((Foo)t.f1).t.f1)).isEqualTo(12L);
        FieldAccessor f1tf0 = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"f1.t.f0", null);
        Assertions.assertThat((Class)f1tf0.getFieldType().getTypeClass()).isEqualTo(String.class);
        Assertions.assertThat((String)((String)f1tf0.get((Object)t))).isEqualTo("ddd");
        Assertions.assertThat((String)((String)((Foo)t.f1).t.f0)).isEqualTo("ddd");
        t = (Tuple2)f1tf0.set((Object)t, (Object)"alma");
        Assertions.assertThat((String)((String)f1tf0.get((Object)t))).isEqualTo("alma");
        Assertions.assertThat((String)((String)((Foo)t.f1).t.f0)).isEqualTo("alma");
        FieldAccessor f1 = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"f1", null);
        FieldAccessor f1n = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (int)1, null);
        Assertions.assertThat((Class)f1.getFieldType().getTypeClass()).isEqualTo(Foo.class);
        Assertions.assertThat((Class)f1n.getFieldType().getTypeClass()).isEqualTo(Foo.class);
        Assertions.assertThat(((Foo)f1.get((Object)t)).t).isEqualTo((Object)Tuple2.of((Object)"alma", (Object)12L));
        Assertions.assertThat(((Foo)f1n.get((Object)t)).t).isEqualTo((Object)Tuple2.of((Object)"alma", (Object)12L));
        Assertions.assertThat(((Foo)t.f1).t).isEqualTo((Object)Tuple2.of((Object)"alma", (Object)12L));
        Foo newFoo = new Foo(8, (Tuple2<String, Long>)Tuple2.of((Object)"ddd", (Object)9L), (short)2);
        f1.set((Object)t, (Object)newFoo);
        Assertions.assertThat((Object)((Foo)f1.get((Object)t))).isEqualTo((Object)newFoo);
        Assertions.assertThat((Object)((Foo)f1n.get((Object)t))).isEqualTo((Object)newFoo);
        Assertions.assertThat((Object)((Foo)t.f1)).isEqualTo((Object)newFoo);
    }

    @Test
    void testIllegalTupleInPojoInTuple() {
        Tuple2 t = Tuple2.of((Object)"aa", (Object)new Foo(8, (Tuple2<String, Long>)Tuple2.of((Object)"ddd", (Object)9L), (short)2));
        TupleTypeInfo tpeInfo = (TupleTypeInfo)TypeExtractor.getForObject((Object)t);
        Assertions.assertThatThrownBy(() -> FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"illegal.illegal.illegal", null)).isInstanceOf(CompositeType.InvalidFieldReferenceException.class);
    }

    @Test
    void testPojoInPojo() {
        Outer o = new Outer(10, new Inner(4L), 12);
        PojoTypeInfo tpeInfo = (PojoTypeInfo)TypeInformation.of(Outer.class);
        FieldAccessor fix = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"i.x", null);
        Assertions.assertThat((Class)fix.getFieldType().getTypeClass()).isEqualTo(Long.class);
        Assertions.assertThat((Long)((Long)fix.get((Object)o))).isEqualTo(4L);
        Assertions.assertThat((long)o.i.x).isEqualTo(4L);
        o = (Outer)fix.set((Object)o, (Object)22L);
        Assertions.assertThat((Long)((Long)fix.get((Object)o))).isEqualTo(22L);
        Assertions.assertThat((long)o.i.x).isEqualTo(22L);
        FieldAccessor fi = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"i", null);
        Assertions.assertThat((Class)fi.getFieldType().getTypeClass()).isEqualTo(Inner.class);
        Assertions.assertThat((long)((Inner)fi.get((Object)o)).x).isEqualTo(22L);
        Assertions.assertThat((Long)((Long)fix.get((Object)o))).isEqualTo(22L);
        Assertions.assertThat((long)o.i.x).isEqualTo(22L);
        o = (Outer)fi.set((Object)o, (Object)new Inner(30L));
        Assertions.assertThat((long)((Inner)fi.get((Object)o)).x).isEqualTo(30L);
        Assertions.assertThat((Long)((Long)fix.get((Object)o))).isEqualTo(30L);
        Assertions.assertThat((long)o.i.x).isEqualTo(30L);
    }

    @Test
    void testArray() {
        int[] a = new int[]{3, 5};
        FieldAccessor fieldAccessor = FieldAccessorFactory.getAccessor((TypeInformation)PrimitiveArrayTypeInfo.getInfoFor(a.getClass()), (int)1, null);
        Assertions.assertThat((Class)fieldAccessor.getFieldType().getTypeClass()).isEqualTo(Integer.class);
        Assertions.assertThat((Integer)((Integer)fieldAccessor.get((Object)a))).isEqualTo(a[1]);
        a = (int[])fieldAccessor.set((Object)a, (Object)6);
        Assertions.assertThat((Integer)((Integer)fieldAccessor.get((Object)a))).isEqualTo(a[1]);
        Integer[] b = new Integer[]{3, 5};
        FieldAccessor fieldAccessor2 = FieldAccessorFactory.getAccessor((TypeInformation)BasicArrayTypeInfo.getInfoFor(b.getClass()), (int)1, null);
        Assertions.assertThat((Class)fieldAccessor2.getFieldType().getTypeClass()).isEqualTo(Integer.class);
        Assertions.assertThat((Integer)((Integer)fieldAccessor2.get((Object)b))).isEqualTo((Object)b[1]);
        b = (Integer[])fieldAccessor2.set((Object)b, (Object)6);
        Assertions.assertThat((Integer)((Integer)fieldAccessor2.get((Object)b))).isEqualTo((Object)b[1]);
    }

    @Test
    void testArrayInPojo() {
        ArrayInPojo o = new ArrayInPojo(10L, new int[]{3, 4, 5}, 12);
        PojoTypeInfo tpeInfo = (PojoTypeInfo)TypeInformation.of(ArrayInPojo.class);
        FieldAccessor fix = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"arr.1", null);
        Assertions.assertThat((Class)fix.getFieldType().getTypeClass()).isEqualTo(Integer.class);
        Assertions.assertThat((Integer)((Integer)fix.get((Object)o))).isEqualTo(4);
        Assertions.assertThat((int)o.arr[1]).isEqualTo(4L);
        o = (ArrayInPojo)fix.set((Object)o, (Object)8);
        Assertions.assertThat((Integer)((Integer)fix.get((Object)o))).isEqualTo(8);
        Assertions.assertThat((int)o.arr[1]).isEqualTo(8);
    }

    @Test
    void testBasicType() {
        Long x = 7L;
        BasicTypeInfo tpeInfo = BasicTypeInfo.LONG_TYPE_INFO;
        FieldAccessor f = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (int)0, null);
        Assertions.assertThat((Class)f.getFieldType().getTypeClass()).isEqualTo(Long.class);
        Assertions.assertThat((Long)((Long)f.get((Object)x))).isEqualTo(7L);
        x = (Long)f.set((Object)x, (Object)12L);
        Assertions.assertThat((Long)((Long)f.get((Object)x))).isEqualTo(12L);
        Assertions.assertThat((Long)x).isEqualTo(12L);
        FieldAccessor f2 = FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"*", null);
        Assertions.assertThat((Class)f2.getFieldType().getTypeClass()).isEqualTo(Long.class);
        Assertions.assertThat((Long)((Long)f2.get((Object)x))).isEqualTo(12L);
        x = (Long)f2.set((Object)x, (Object)14L);
        Assertions.assertThat((Long)((Long)f2.get((Object)x))).isEqualTo(14L);
        Assertions.assertThat((Long)x).isEqualTo(14L);
    }

    @Test
    void testIllegalBasicType1() {
        BasicTypeInfo tpeInfo = BasicTypeInfo.LONG_TYPE_INFO;
        Assertions.assertThatThrownBy(() -> FieldAccessorTest.lambda$testIllegalBasicType1$3((TypeInformation)tpeInfo)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testIllegalBasicType2() {
        BasicTypeInfo tpeInfo = BasicTypeInfo.LONG_TYPE_INFO;
        Assertions.assertThatThrownBy(() -> FieldAccessorTest.lambda$testIllegalBasicType2$4((TypeInformation)tpeInfo)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testRowTypeInfo() {
        TypeInformation[] typeList = new TypeInformation[]{new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.SHORT_TYPE_INFO, BasicTypeInfo.BIG_DEC_TYPE_INFO})};
        String[] fieldNames = new String[]{"row"};
        RowTypeInfo rowTypeInfo = new RowTypeInfo(typeList, fieldNames);
        Assertions.assertThatThrownBy(() -> FieldAccessorFactory.getAccessor((TypeInformation)rowTypeInfo, (String)"row.0", null)).isInstanceOf(CompositeType.InvalidFieldReferenceException.class);
    }

    private static /* synthetic */ void lambda$testIllegalBasicType2$4(TypeInformation tpeInfo) throws Throwable {
        FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (String)"foo", null);
    }

    private static /* synthetic */ void lambda$testIllegalBasicType1$3(TypeInformation tpeInfo) throws Throwable {
        FieldAccessorFactory.getAccessor((TypeInformation)tpeInfo, (int)1, null);
    }

    public static class ArrayInPojo {
        public long x;
        public int[] arr;
        public int y;

        public ArrayInPojo() {
        }

        public ArrayInPojo(long x, int[] arr, int y) {
            this.x = x;
            this.arr = arr;
            this.y = y;
        }
    }

    public static class Outer {
        public int a;
        public Inner i;
        public short b;

        public Outer() {
        }

        public Outer(int a, Inner i, short b) {
            this.a = a;
            this.i = i;
            this.b = b;
        }

        public String toString() {
            return this.a + ", " + this.i.toString() + ", " + this.b;
        }
    }

    public static class Inner {
        public long x;
        public boolean b;

        public Inner() {
        }

        public Inner(long x) {
            this.x = x;
        }

        public Inner(long x, boolean b) {
            this.x = x;
            this.b = b;
        }

        public String toString() {
            return Long.valueOf(this.x).toString() + ", " + this.b;
        }
    }

    public static class Foo {
        public int x;
        public Tuple2<String, Long> t;
        public Short y;

        public Foo() {
        }

        public Foo(int x, Tuple2<String, Long> t, Short y) {
            this.x = x;
            this.t = t;
            this.y = y;
        }
    }
}

