/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.time.Duration;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.RestartStrategyOptions;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;

public class RestartStrategyUtils {
    public static void configureNoRestartStrategy(StreamExecutionEnvironment env) {
        env.configure((ReadableConfig)new Configuration().set(RestartStrategyOptions.RESTART_STRATEGY, (Object)"none"));
    }

    public static void configureNoRestartStrategy(JobGraph jobGraph) {
        jobGraph.getJobConfiguration().set(RestartStrategyOptions.RESTART_STRATEGY, (Object)"none");
    }

    public static void configureFixedDelayRestartStrategy(StreamExecutionEnvironment env, int restartAttempts, long delayBetweenAttempts) {
        RestartStrategyUtils.configureFixedDelayRestartStrategy(env, restartAttempts, Duration.ofMillis(delayBetweenAttempts));
    }

    public static void configureFixedDelayRestartStrategy(StreamExecutionEnvironment env, int restartAttempts, Duration delayBetweenAttempts) {
        Configuration configuration = new Configuration();
        configuration.set(RestartStrategyOptions.RESTART_STRATEGY, (Object)"fixed-delay");
        configuration.set(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_ATTEMPTS, (Object)restartAttempts);
        configuration.set(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_DELAY, (Object)delayBetweenAttempts);
        env.configure((ReadableConfig)configuration);
    }

    public static void configureFixedDelayRestartStrategy(JobGraph jobGraph, int restartAttempts, long delayBetweenAttempts) {
        RestartStrategyUtils.configureFixedDelayRestartStrategy(jobGraph, restartAttempts, Duration.ofMillis(delayBetweenAttempts));
    }

    public static void configureFixedDelayRestartStrategy(JobGraph jobGraph, int restartAttempts, Duration delayBetweenAttempts) {
        Configuration configuration = jobGraph.getJobConfiguration();
        configuration.set(RestartStrategyOptions.RESTART_STRATEGY, (Object)"fixed-delay");
        configuration.set(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_ATTEMPTS, (Object)restartAttempts);
        configuration.set(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_DELAY, (Object)delayBetweenAttempts);
    }
}

