/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.time.Duration;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.ProcessOperator;
import org.apache.flink.streaming.util.AbstractStreamOperatorTestHarness;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.util.Collector;
import org.apache.flink.util.OutputTag;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class AbstractStreamOperatorTestHarnessTest {
    AbstractStreamOperatorTestHarnessTest() {
    }

    @Test
    void testInitializeAfterOpenning() throws Throwable {
        AbstractStreamOperatorTestHarness result = new AbstractStreamOperatorTestHarness(new AbstractStreamOperator<Integer>(){}, 1, 1, 0);
        result.setup();
        result.open();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> result.initializeState(OperatorSubtaskState.builder().build())).isInstanceOf(IllegalStateException.class)).hasMessageContaining("TestHarness has already been initialized.");
    }

    @Test
    void testSetTtlTimeProvider() throws Exception {
        AbstractStreamOperator<Integer> operator = new AbstractStreamOperator<Integer>(){};
        try (AbstractStreamOperatorTestHarness result = new AbstractStreamOperatorTestHarness(operator, 1, 1, 0);){
            result.config.setStateKeySerializer((TypeSerializer)IntSerializer.INSTANCE);
            result.config.serializeAllConfigs();
            Duration timeToLive = Duration.ofHours(1L);
            result.initializeState(OperatorSubtaskState.builder().build());
            result.open();
            ValueStateDescriptor stateDescriptor = new ValueStateDescriptor("test", (TypeSerializer)IntSerializer.INSTANCE);
            stateDescriptor.enableTimeToLive(StateTtlConfig.newBuilder((Duration)timeToLive).build());
            KeyedStateBackend keyedStateBackend = operator.getKeyedStateBackend();
            ValueState state = (ValueState)keyedStateBackend.getPartitionedState((Object)VoidNamespace.INSTANCE, (TypeSerializer)VoidNamespaceSerializer.INSTANCE, (StateDescriptor)stateDescriptor);
            int expectedValue = 42;
            keyedStateBackend.setCurrentKey((Object)1);
            result.setStateTtlProcessingTime(0L);
            state.update((Object)expectedValue);
            Assertions.assertThat((Integer)((Integer)state.value())).isEqualTo(expectedValue);
            result.setStateTtlProcessingTime(timeToLive.toMillis() + 1L);
            Assertions.assertThat((Integer)((Integer)state.value())).isNull();
        }
    }

    @Test
    void testSideOutputTypeInformation() throws Throwable {
        int probe = 12;
        TypeSerializer typeSerializer = (TypeSerializer)Mockito.spy(TypeSerializer.class);
        TypeInformation typeInformation = (TypeInformation)Mockito.spy((Object)Types.INT);
        Mockito.when((Object)typeInformation.createSerializer((SerializerConfig)ArgumentMatchers.any(SerializerConfigImpl.class))).thenReturn((Object)typeSerializer);
        OutputTag outputTag = new OutputTag("test", typeInformation);
        SideOutputTypeInformationTestFunction testFunction = new SideOutputTypeInformationTestFunction((OutputTag<Integer>)outputTag);
        OneInputStreamOperatorTestHarness result = new OneInputStreamOperatorTestHarness(new ProcessOperator((ProcessFunction)testFunction));
        result.setup();
        result.open();
        result.processElement(12, 1000L);
        ((TypeSerializer)Mockito.verify((Object)typeSerializer, (VerificationMode)Mockito.times((int)1))).copy((Object)ArgumentMatchers.eq((int)12));
    }

    private static class SideOutputTypeInformationTestFunction
    extends ProcessFunction<Integer, Integer> {
        private final OutputTag<Integer> outputTag;

        SideOutputTypeInformationTestFunction(OutputTag<Integer> outputTag) {
            this.outputTag = outputTag;
        }

        public void processElement(Integer value, ProcessFunction.Context ctx, Collector<Integer> out) throws Exception {
            ctx.output(this.outputTag, (Object)value);
        }
    }
}

