/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.time.Duration;
import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.streaming.api.windowing.assigners.SlidingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.triggers.EventTimeTrigger;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class SlidingEventTimeWindowsTest {
    SlidingEventTimeWindowsTest() {
    }

    @Test
    void testWindowAssignment() {
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        SlidingEventTimeWindows assigner = SlidingEventTimeWindows.of((Duration)Duration.ofMillis(5000L), (Duration)Duration.ofMillis(1000L));
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 0L, mockContext)).containsExactlyInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(-4000L, 1000L), new TimeWindow(-3000L, 2000L), new TimeWindow(-2000L, 3000L), new TimeWindow(-1000L, 4000L), new TimeWindow(0L, 5000L)});
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 4999L, mockContext)).containsExactlyInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(0L, 5000L), new TimeWindow(1000L, 6000L), new TimeWindow(2000L, 7000L), new TimeWindow(3000L, 8000L), new TimeWindow(4000L, 9000L)});
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 5000L, mockContext)).containsExactlyInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(1000L, 6000L), new TimeWindow(2000L, 7000L), new TimeWindow(3000L, 8000L), new TimeWindow(4000L, 9000L), new TimeWindow(5000L, 10000L)});
    }

    @Test
    void testWindowAssignmentWithOffset() {
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        SlidingEventTimeWindows assigner = SlidingEventTimeWindows.of((Duration)Duration.ofMillis(5000L), (Duration)Duration.ofMillis(1000L), (Duration)Duration.ofMillis(100L));
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 100L, mockContext)).containsExactlyInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(-3900L, 1100L), new TimeWindow(-2900L, 2100L), new TimeWindow(-1900L, 3100L), new TimeWindow(-900L, 4100L), new TimeWindow(100L, 5100L)});
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 5099L, mockContext)).containsExactlyInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(100L, 5100L), new TimeWindow(1100L, 6100L), new TimeWindow(2100L, 7100L), new TimeWindow(3100L, 8100L), new TimeWindow(4100L, 9100L)});
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 5100L, mockContext)).containsExactlyInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(1100L, 6100L), new TimeWindow(2100L, 7100L), new TimeWindow(3100L, 8100L), new TimeWindow(4100L, 9100L), new TimeWindow(5100L, 10100L)});
    }

    @Test
    void testWindowAssignmentWithNegativeOffset() {
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        SlidingEventTimeWindows assigner = SlidingEventTimeWindows.of((Duration)Duration.ofMillis(5000L), (Duration)Duration.ofMillis(1000L), (Duration)Duration.ofMillis(-100L));
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 0L, mockContext)).containsExactlyInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(-4100L, 900L), new TimeWindow(-3100L, 1900L), new TimeWindow(-2100L, 2900L), new TimeWindow(-1100L, 3900L), new TimeWindow(-100L, 4900L)});
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 4899L, mockContext)).containsExactlyInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(-100L, 4900L), new TimeWindow(900L, 5900L), new TimeWindow(1900L, 6900L), new TimeWindow(2900L, 7900L), new TimeWindow(3900L, 8900L)});
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 4900L, mockContext)).containsExactlyInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(900L, 5900L), new TimeWindow(1900L, 6900L), new TimeWindow(2900L, 7900L), new TimeWindow(3900L, 8900L), new TimeWindow(4900L, 9900L)});
    }

    @Test
    void testTimeUnits() {
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        SlidingEventTimeWindows assigner = SlidingEventTimeWindows.of((Duration)Duration.ofSeconds(5L), (Duration)Duration.ofSeconds(1L), (Duration)Duration.ofMillis(500L));
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 100L, mockContext)).containsExactlyInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(-4500L, 500L), new TimeWindow(-3500L, 1500L), new TimeWindow(-2500L, 2500L), new TimeWindow(-1500L, 3500L), new TimeWindow(-500L, 4500L)});
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 5499L, mockContext)).containsExactlyInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(500L, 5500L), new TimeWindow(1500L, 6500L), new TimeWindow(2500L, 7500L), new TimeWindow(3500L, 8500L), new TimeWindow(4500L, 9500L)});
        Assertions.assertThat((Collection)assigner.assignWindows((Object)"String", 5100L, mockContext)).containsExactlyInAnyOrder((Object[])new TimeWindow[]{new TimeWindow(500L, 5500L), new TimeWindow(1500L, 6500L), new TimeWindow(2500L, 7500L), new TimeWindow(3500L, 8500L), new TimeWindow(4500L, 9500L)});
    }

    @Test
    void testInvalidParameters() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SlidingEventTimeWindows.of((Duration)Duration.ofSeconds(-2L), (Duration)Duration.ofSeconds(1L))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("abs(offset) < slide and size > 0");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SlidingEventTimeWindows.of((Duration)Duration.ofSeconds(2L), (Duration)Duration.ofSeconds(-1L))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("abs(offset) < slide and size > 0");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SlidingEventTimeWindows.of((Duration)Duration.ofSeconds(-20L), (Duration)Duration.ofSeconds(10L), (Duration)Duration.ofSeconds(-1L))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("abs(offset) < slide and size > 0");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SlidingEventTimeWindows.of((Duration)Duration.ofSeconds(20L), (Duration)Duration.ofSeconds(10L), (Duration)Duration.ofSeconds(-11L))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("abs(offset) < slide and size > 0");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SlidingEventTimeWindows.of((Duration)Duration.ofSeconds(20L), (Duration)Duration.ofSeconds(10L), (Duration)Duration.ofSeconds(11L))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("abs(offset) < slide and size > 0");
    }

    @Test
    void testProperties() {
        SlidingEventTimeWindows assigner = SlidingEventTimeWindows.of((Duration)Duration.ofSeconds(5L), (Duration)Duration.ofMillis(100L));
        Assertions.assertThat((boolean)assigner.isEventTime()).isTrue();
        Assertions.assertThat((Object)assigner.getWindowSerializer(new ExecutionConfig())).isEqualTo((Object)new TimeWindow.Serializer());
        Assertions.assertThat((Object)assigner.getDefaultTrigger()).isInstanceOf(EventTimeTrigger.class);
    }
}

