/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.io.Closeable;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.runtime.state.CheckpointStateOutputStream;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.CheckpointedStateScope;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateCheckpointOutputStream;
import org.apache.flink.runtime.state.OperatorStateCheckpointOutputStream;
import org.apache.flink.runtime.state.StateSnapshotContextSynchronousImpl;
import org.apache.flink.runtime.state.memory.MemCheckpointStreamFactory;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class StateSnapshotContextSynchronousImplTest {
    private StateSnapshotContextSynchronousImpl snapshotContext;

    StateSnapshotContextSynchronousImplTest() {
    }

    @BeforeEach
    void setUp() {
        CloseableRegistry closableRegistry = new CloseableRegistry();
        MemCheckpointStreamFactory streamFactory = new MemCheckpointStreamFactory(1024);
        KeyGroupRange keyGroupRange = new KeyGroupRange(0, 2);
        this.snapshotContext = new StateSnapshotContextSynchronousImpl(42L, 4711L, (CheckpointStreamFactory)streamFactory, keyGroupRange, closableRegistry);
    }

    @Test
    void testMetaData() {
        Assertions.assertThat((long)this.snapshotContext.getCheckpointId()).isEqualTo(42L);
        Assertions.assertThat((long)this.snapshotContext.getCheckpointTimestamp()).isEqualTo(4711L);
    }

    @Test
    void testCreateRawKeyedStateOutput() throws Exception {
        KeyedStateCheckpointOutputStream stream = this.snapshotContext.getRawKeyedOperatorStateOutput();
        Assertions.assertThat((Object)stream).isNotNull();
    }

    @Test
    void testCreateRawOperatorStateOutput() throws Exception {
        OperatorStateCheckpointOutputStream stream = this.snapshotContext.getRawOperatorStateOutput();
        Assertions.assertThat((Object)stream).isNotNull();
    }

    @Test
    void testStreamClosingWhenClosing() throws Exception {
        long checkpointId = 42L;
        long checkpointTimestamp = 1L;
        CheckpointStateOutputStream outputStream1 = (CheckpointStateOutputStream)Mockito.mock(CheckpointStateOutputStream.class);
        CheckpointStateOutputStream outputStream2 = (CheckpointStateOutputStream)Mockito.mock(CheckpointStateOutputStream.class);
        CheckpointStreamFactory streamFactory = (CheckpointStreamFactory)Mockito.mock(CheckpointStreamFactory.class);
        Mockito.when((Object)streamFactory.createCheckpointStateOutputStream(CheckpointedStateScope.EXCLUSIVE)).thenReturn((Object)outputStream1, (Object[])new CheckpointStateOutputStream[]{outputStream2});
        InsightCloseableRegistry closableRegistry = new InsightCloseableRegistry();
        KeyGroupRange keyGroupRange = new KeyGroupRange(0, 2);
        StateSnapshotContextSynchronousImpl context = new StateSnapshotContextSynchronousImpl(checkpointId, checkpointTimestamp, streamFactory, keyGroupRange, (CloseableRegistry)closableRegistry);
        context.getRawKeyedOperatorStateOutput();
        context.getRawOperatorStateOutput();
        ((CheckpointStreamFactory)Mockito.verify((Object)streamFactory, (VerificationMode)Mockito.times((int)2))).createCheckpointStateOutputStream(CheckpointedStateScope.EXCLUSIVE);
        Assertions.assertThat((int)closableRegistry.size()).isEqualTo(2);
        Assertions.assertThat((boolean)closableRegistry.contains((Closeable)outputStream1)).isTrue();
        Assertions.assertThat((boolean)closableRegistry.contains((Closeable)outputStream2)).isTrue();
        context.getKeyedStateStreamFuture().run();
        context.getOperatorStateStreamFuture().run();
        ((CheckpointStateOutputStream)Mockito.verify((Object)outputStream1)).closeAndGetHandle();
        ((CheckpointStateOutputStream)Mockito.verify((Object)outputStream2)).closeAndGetHandle();
        Assertions.assertThat((int)closableRegistry.size()).isZero();
    }

    @Test
    void testStreamClosingExceptionally() throws Exception {
        long checkpointId = 42L;
        long checkpointTimestamp = 1L;
        CheckpointStateOutputStream outputStream1 = (CheckpointStateOutputStream)Mockito.mock(CheckpointStateOutputStream.class);
        CheckpointStateOutputStream outputStream2 = (CheckpointStateOutputStream)Mockito.mock(CheckpointStateOutputStream.class);
        CheckpointStreamFactory streamFactory = (CheckpointStreamFactory)Mockito.mock(CheckpointStreamFactory.class);
        Mockito.when((Object)streamFactory.createCheckpointStateOutputStream(CheckpointedStateScope.EXCLUSIVE)).thenReturn((Object)outputStream1, (Object[])new CheckpointStateOutputStream[]{outputStream2});
        InsightCloseableRegistry closableRegistry = new InsightCloseableRegistry();
        KeyGroupRange keyGroupRange = new KeyGroupRange(0, 2);
        StateSnapshotContextSynchronousImpl context = new StateSnapshotContextSynchronousImpl(checkpointId, checkpointTimestamp, streamFactory, keyGroupRange, (CloseableRegistry)closableRegistry);
        context.getRawKeyedOperatorStateOutput();
        context.getRawOperatorStateOutput();
        ((CheckpointStreamFactory)Mockito.verify((Object)streamFactory, (VerificationMode)Mockito.times((int)2))).createCheckpointStateOutputStream(CheckpointedStateScope.EXCLUSIVE);
        Assertions.assertThat((int)closableRegistry.size()).isEqualTo(2);
        Assertions.assertThat((boolean)closableRegistry.contains((Closeable)outputStream1)).isTrue();
        Assertions.assertThat((boolean)closableRegistry.contains((Closeable)outputStream2)).isTrue();
        context.closeExceptionally();
        ((CheckpointStateOutputStream)Mockito.verify((Object)outputStream1)).close();
        ((CheckpointStateOutputStream)Mockito.verify((Object)outputStream2)).close();
        Assertions.assertThat((int)closableRegistry.size()).isZero();
    }

    static final class InsightCloseableRegistry
    extends CloseableRegistry {
        InsightCloseableRegistry() {
        }

        public int size() {
            return this.getNumberOfRegisteredCloseables();
        }

        public boolean contains(Closeable closeable) {
            return this.isCloseableRegistered(closeable);
        }
    }
}

