/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.StateHandleDummyUtil;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.state.DoneFuture;
import org.apache.flink.runtime.state.InputChannelStateHandle;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.ResultSubpartitionStateHandle;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.streaming.api.operators.OperatorSnapshotFinalizer;
import org.apache.flink.streaming.api.operators.OperatorSnapshotFutures;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class OperatorSnapshotFinalizerTest {
    OperatorSnapshotFinalizerTest() {
    }

    @Test
    void testRunAndExtract() throws Exception {
        Random random = new Random(66L);
        KeyedStateHandle keyedTemplate = StateHandleDummyUtil.createNewKeyedStateHandle(new KeyGroupRange(0, 0));
        OperatorStateHandle operatorTemplate = StateHandleDummyUtil.createNewOperatorStateHandle(2, random);
        InputChannelStateHandle inputChannelTemplate = StateHandleDummyUtil.createNewInputChannelStateHandle(2, random);
        ResultSubpartitionStateHandle resultSubpartitionTemplate = StateHandleDummyUtil.createNewResultSubpartitionStateHandle(2, random);
        SnapshotResult manKeyed = SnapshotResult.withLocalState((StateObject)StateHandleDummyUtil.deepDummyCopy(keyedTemplate), (StateObject)StateHandleDummyUtil.deepDummyCopy(keyedTemplate));
        SnapshotResult rawKeyed = SnapshotResult.withLocalState((StateObject)StateHandleDummyUtil.deepDummyCopy(keyedTemplate), (StateObject)StateHandleDummyUtil.deepDummyCopy(keyedTemplate));
        SnapshotResult manOper = SnapshotResult.withLocalState((StateObject)StateHandleDummyUtil.deepDummyCopy(operatorTemplate), (StateObject)StateHandleDummyUtil.deepDummyCopy(operatorTemplate));
        SnapshotResult rawOper = SnapshotResult.withLocalState((StateObject)StateHandleDummyUtil.deepDummyCopy(operatorTemplate), (StateObject)StateHandleDummyUtil.deepDummyCopy(operatorTemplate));
        SnapshotResult inputChannel = SnapshotResult.withLocalState((StateObject)StateObjectCollection.singleton((StateObject)StateHandleDummyUtil.deepDummyCopy(inputChannelTemplate)), (StateObject)StateObjectCollection.singleton((StateObject)StateHandleDummyUtil.deepDummyCopy(inputChannelTemplate)));
        SnapshotResult resultSubpartition = SnapshotResult.withLocalState((StateObject)StateObjectCollection.singleton((StateObject)StateHandleDummyUtil.deepDummyCopy(resultSubpartitionTemplate)), (StateObject)StateObjectCollection.singleton((StateObject)StateHandleDummyUtil.deepDummyCopy(resultSubpartitionTemplate)));
        OperatorSnapshotFutures snapshotFutures = new OperatorSnapshotFutures(new PseudoNotDoneFuture<SnapshotResult>(manKeyed), new PseudoNotDoneFuture<SnapshotResult>(rawKeyed), new PseudoNotDoneFuture<SnapshotResult>(manOper), new PseudoNotDoneFuture<SnapshotResult>(rawOper), new PseudoNotDoneFuture<SnapshotResult>(inputChannel), new PseudoNotDoneFuture<SnapshotResult>(resultSubpartition));
        for (Future f : snapshotFutures.getAllFutures()) {
            Assertions.assertThat((Future)f).isNotDone();
        }
        OperatorSnapshotFinalizer finalizer = new OperatorSnapshotFinalizer(snapshotFutures);
        for (Future f : snapshotFutures.getAllFutures()) {
            Assertions.assertThat((Future)f).isDone();
        }
        HashMap<SnapshotResult, Function<OperatorSubtaskState, Object>> map = new HashMap<SnapshotResult, Function<OperatorSubtaskState, Object>>();
        map.put(manKeyed, OperatorSnapshotFinalizerTest.headExtractor(OperatorSubtaskState::getManagedKeyedState));
        map.put(rawKeyed, OperatorSnapshotFinalizerTest.headExtractor(OperatorSubtaskState::getRawKeyedState));
        map.put(manOper, OperatorSnapshotFinalizerTest.headExtractor(OperatorSubtaskState::getManagedOperatorState));
        map.put(rawOper, OperatorSnapshotFinalizerTest.headExtractor(OperatorSubtaskState::getRawOperatorState));
        map.put(inputChannel, OperatorSubtaskState::getInputChannelState);
        map.put(resultSubpartition, OperatorSubtaskState::getResultSubpartitionState);
        for (Map.Entry e : map.entrySet()) {
            Assertions.assertThat((Object)((StateObject)((Function)e.getValue()).apply(finalizer.getJobManagerOwnedState()))).isEqualTo((Object)((SnapshotResult)e.getKey()).getJobManagerOwnedSnapshot());
        }
        for (Map.Entry e : map.entrySet()) {
            Assertions.assertThat((Object)((StateObject)((Function)e.getValue()).apply(finalizer.getTaskLocalState()))).isEqualTo((Object)((SnapshotResult)e.getKey()).getTaskLocalSnapshot());
        }
    }

    private static <T extends StateObject> Function<OperatorSubtaskState, T> headExtractor(Function<OperatorSubtaskState, StateObjectCollection<T>> collectionExtractor) {
        return collectionExtractor.andThen(col -> col == null || col.isEmpty() ? null : (StateObject)col.iterator().next());
    }

    private void checkResult(Object expected, StateObjectCollection<?> actual) {
        if (expected == null) {
            Assertions.assertThat((actual == null || actual.isEmpty() ? 1 : 0) != 0).isTrue();
        } else {
            Assertions.assertThat(actual).hasSize(1);
            Assertions.assertThat((Object)((StateObject)actual.iterator().next())).isEqualTo(expected);
        }
    }

    static class PseudoNotDoneFuture<T>
    extends DoneFuture<T> {
        private boolean done = false;

        PseudoNotDoneFuture(T payload) {
            super(payload);
        }

        public void run() {
            super.run();
            this.done = true;
        }

        public boolean isDone() {
            return this.done;
        }

        public T get() {
            try {
                Object object = super.get();
                return (T)object;
            }
            finally {
                this.done = true;
            }
        }
    }
}

