/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import org.apache.flink.streaming.api.operators.InputSelection;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class InputSelectionTest {
    InputSelectionTest() {
    }

    @Test
    void testIsInputSelected() {
        Assertions.assertThat((boolean)new InputSelection.Builder().build().isInputSelected(1)).isFalse();
        Assertions.assertThat((boolean)new InputSelection.Builder().select(2).build().isInputSelected(1)).isFalse();
        Assertions.assertThat((boolean)new InputSelection.Builder().select(1).build().isInputSelected(1)).isTrue();
        Assertions.assertThat((boolean)new InputSelection.Builder().select(1).select(2).build().isInputSelected(1)).isTrue();
        Assertions.assertThat((boolean)new InputSelection.Builder().select(-1).build().isInputSelected(1)).isTrue();
        Assertions.assertThat((boolean)new InputSelection.Builder().select(64).build().isInputSelected(64)).isTrue();
    }

    @Test
    void testInputSelectionNormalization() {
        Assertions.assertThat((boolean)InputSelection.ALL.areAllInputsSelected()).isTrue();
        Assertions.assertThat((boolean)new InputSelection.Builder().select(1).select(2).build().areAllInputsSelected()).isFalse();
        Assertions.assertThat((boolean)new InputSelection.Builder().select(1).select(2).build(2).areAllInputsSelected()).isTrue();
        Assertions.assertThat((boolean)new InputSelection.Builder().select(1).select(2).select(3).build().areAllInputsSelected()).isFalse();
        Assertions.assertThat((boolean)new InputSelection.Builder().select(1).select(2).select(3).build(3).areAllInputsSelected()).isTrue();
        Assertions.assertThat((boolean)new InputSelection.Builder().select(1).select(3).build().areAllInputsSelected()).isFalse();
        Assertions.assertThat((boolean)new InputSelection.Builder().select(1).select(3).build(3).areAllInputsSelected()).isFalse();
        Assertions.assertThat((boolean)InputSelection.FIRST.areAllInputsSelected()).isFalse();
        Assertions.assertThat((boolean)InputSelection.SECOND.areAllInputsSelected()).isFalse();
    }

    @Test
    void testInputSelectionNormalizationOverflow() {
        Assertions.assertThatThrownBy(() -> new InputSelection.Builder().select(3).build(2)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testFairSelectNextIndexOutOf2() {
        Assertions.assertThat((int)InputSelection.ALL.fairSelectNextIndexOutOf2(3, 0)).isOne();
        Assertions.assertThat((int)new InputSelection.Builder().select(1).select(2).build().fairSelectNextIndexOutOf2(3, 1)).isZero();
        Assertions.assertThat((int)InputSelection.ALL.fairSelectNextIndexOutOf2(2, 0)).isOne();
        Assertions.assertThat((int)InputSelection.ALL.fairSelectNextIndexOutOf2(2, 1)).isOne();
        Assertions.assertThat((int)InputSelection.ALL.fairSelectNextIndexOutOf2(1, 0)).isZero();
        Assertions.assertThat((int)InputSelection.ALL.fairSelectNextIndexOutOf2(1, 1)).isZero();
        Assertions.assertThat((int)InputSelection.ALL.fairSelectNextIndexOutOf2(0, 0)).isEqualTo(-1);
        Assertions.assertThat((int)InputSelection.ALL.fairSelectNextIndexOutOf2(0, 1)).isEqualTo(-1);
        Assertions.assertThat((int)InputSelection.FIRST.fairSelectNextIndexOutOf2(1, 0)).isZero();
        Assertions.assertThat((int)InputSelection.FIRST.fairSelectNextIndexOutOf2(3, 0)).isZero();
        Assertions.assertThat((int)InputSelection.FIRST.fairSelectNextIndexOutOf2(2, 0)).isEqualTo(-1);
        Assertions.assertThat((int)InputSelection.FIRST.fairSelectNextIndexOutOf2(0, 0)).isEqualTo(-1);
        Assertions.assertThat((int)InputSelection.SECOND.fairSelectNextIndexOutOf2(2, 1)).isOne();
        Assertions.assertThat((int)InputSelection.SECOND.fairSelectNextIndexOutOf2(3, 1)).isOne();
        Assertions.assertThat((int)InputSelection.SECOND.fairSelectNextIndexOutOf2(1, 1)).isEqualTo(-1);
        Assertions.assertThat((int)InputSelection.SECOND.fairSelectNextIndexOutOf2(0, 1)).isEqualTo(-1);
    }

    @Test
    void testFairSelectNextIndexWithAllInputsSelected() {
        Assertions.assertThat((int)InputSelection.ALL.fairSelectNextIndex(7L, 0)).isOne();
        Assertions.assertThat((int)InputSelection.ALL.fairSelectNextIndex(7L, 1)).isEqualTo(2);
        Assertions.assertThat((int)InputSelection.ALL.fairSelectNextIndex(7L, 2)).isZero();
        Assertions.assertThat((int)InputSelection.ALL.fairSelectNextIndex(7L, 0)).isOne();
        Assertions.assertThat((int)InputSelection.ALL.fairSelectNextIndex(0L, 2)).isEqualTo(-1);
        Assertions.assertThat((int)InputSelection.ALL.fairSelectNextIndex(-1L, 10)).isEqualTo(11);
        Assertions.assertThat((int)InputSelection.ALL.fairSelectNextIndex(-1L, 63)).isZero();
        Assertions.assertThat((int)InputSelection.ALL.fairSelectNextIndex(-1L, 158)).isZero();
    }

    @Test
    void testFairSelectNextIndexWithSomeInputsSelected() {
        InputSelection selection = new InputSelection.Builder().select(2).select(3).select(4).select(5).select(8).build();
        int availableInputs = (int)new InputSelection.Builder().select(3).select(5).select(6).select(8).build().getInputMask();
        Assertions.assertThat((int)selection.fairSelectNextIndex((long)availableInputs, 0)).isEqualTo(2);
        Assertions.assertThat((int)selection.fairSelectNextIndex((long)availableInputs, 1)).isEqualTo(2);
        Assertions.assertThat((int)selection.fairSelectNextIndex((long)availableInputs, 2)).isEqualTo(4);
        Assertions.assertThat((int)selection.fairSelectNextIndex((long)availableInputs, 3)).isEqualTo(4);
        Assertions.assertThat((int)selection.fairSelectNextIndex((long)availableInputs, 4)).isEqualTo(7);
        Assertions.assertThat((int)selection.fairSelectNextIndex((long)availableInputs, 5)).isEqualTo(7);
        Assertions.assertThat((int)selection.fairSelectNextIndex((long)availableInputs, 6)).isEqualTo(7);
        Assertions.assertThat((int)selection.fairSelectNextIndex((long)availableInputs, 7)).isEqualTo(2);
        Assertions.assertThat((int)selection.fairSelectNextIndex((long)availableInputs, 8)).isEqualTo(2);
        Assertions.assertThat((int)selection.fairSelectNextIndex((long)availableInputs, 158)).isEqualTo(2);
        Assertions.assertThat((int)selection.fairSelectNextIndex(0L, 5)).isEqualTo(-1);
        Assertions.assertThat((int)new InputSelection.Builder().build().fairSelectNextIndex(-1L, 5)).isEqualTo(-1);
    }

    @Test
    void testUnsupportedFairSelectNextIndexOutOf2() {
        Assertions.assertThatThrownBy(() -> InputSelection.ALL.fairSelectNextIndexOutOf2(7, 0)).isInstanceOf(UnsupportedOperationException.class);
    }

    static class BuilderTest {
        BuilderTest() {
        }

        @Test
        void testSelect() {
            Assertions.assertThat((long)new InputSelection.Builder().select(1).build().getInputMask()).isOne();
            Assertions.assertThat((long)new InputSelection.Builder().select(1).select(2).select(3).build().getInputMask()).isEqualTo(7L);
            Assertions.assertThat((long)new InputSelection.Builder().select(64).build().getInputMask()).isEqualTo(Long.MIN_VALUE);
            Assertions.assertThat((long)new InputSelection.Builder().select(-1).build().getInputMask()).isEqualTo(-1L);
        }

        @Test
        void testIllegalInputId1() {
            Assertions.assertThatThrownBy(() -> new InputSelection.Builder().select(-2)).isInstanceOf(IllegalArgumentException.class);
        }

        @Test
        void testIllegalInputId2() {
            Assertions.assertThatThrownBy(() -> new InputSelection.Builder().select(65)).isInstanceOf(IllegalArgumentException.class);
        }
    }
}

