/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl.mock;

import java.util.HashMap;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.query.KvStateRegistry;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.AbstractStateBackend;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.DefaultOperatorStateBackend;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.SnapshotExecutionType;
import org.apache.flink.runtime.state.SnapshotResources;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.runtime.state.SnapshotStrategy;
import org.apache.flink.runtime.state.SnapshotStrategyRunner;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.metrics.LatencyTrackingStateConfig;
import org.apache.flink.runtime.state.ttl.mock.MockKeyedStateBackend;
import org.apache.flink.runtime.state.ttl.mock.MockKeyedStateBackendBuilder;

public class MockStateBackend
extends AbstractStateBackend {
    private static final long serialVersionUID = 995676510267499393L;
    private MockKeyedStateBackend.MockSnapshotSupplier snapshotSupplier;

    public MockStateBackend() {
        this(MockKeyedStateBackend.MockSnapshotSupplier.DEFAULT);
    }

    public MockStateBackend(MockKeyedStateBackend.MockSnapshotSupplier snapshotSupplier) {
        this.snapshotSupplier = snapshotSupplier;
    }

    public <K> AbstractKeyedStateBackend<K> createKeyedStateBackend(StateBackend.KeyedStateBackendParameters<K> parameters) {
        return new MockKeyedStateBackendBuilder(new KvStateRegistry().createTaskRegistry(parameters.getJobID(), new JobVertexID()), parameters.getKeySerializer(), parameters.getEnv().getUserCodeClassLoader().asClassLoader(), parameters.getNumberOfKeyGroups(), parameters.getKeyGroupRange(), parameters.getEnv().getExecutionConfig(), parameters.getTtlTimeProvider(), LatencyTrackingStateConfig.disabled(), parameters.getStateHandles(), AbstractStateBackend.getCompressionDecorator((ExecutionConfig)parameters.getEnv().getExecutionConfig()), parameters.getCancelStreamRegistry(), this.snapshotSupplier).build();
    }

    public OperatorStateBackend createOperatorStateBackend(StateBackend.OperatorStateBackendParameters parameters) {
        return new DefaultOperatorStateBackend(parameters.getEnv().getExecutionConfig(), parameters.getCancelStreamRegistry(), new HashMap(), new HashMap(), new HashMap(), new HashMap(), new SnapshotStrategyRunner("", (SnapshotStrategy)new SnapshotStrategy<OperatorStateHandle, SnapshotResources>(){

            public SnapshotResources syncPrepareResources(long checkpointId) {
                return () -> {};
            }

            public SnapshotStrategy.SnapshotResultSupplier<OperatorStateHandle> asyncSnapshot(SnapshotResources syncPartResource, long checkpointId, long timestamp, @Nonnull CheckpointStreamFactory streamFactory, @Nonnull CheckpointOptions checkpointOptions) {
                return snapshotCloseableRegistry -> SnapshotResult.empty();
            }
        }, new CloseableRegistry(), SnapshotExecutionType.ASYNCHRONOUS));
    }
}

