/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive.allocator;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.scheduler.adaptive.JobSchedulingPlan;
import org.apache.flink.runtime.scheduler.adaptive.allocator.JobAllocationsInformation;
import org.apache.flink.runtime.scheduler.adaptive.allocator.JobInformation;
import org.apache.flink.runtime.scheduler.adaptive.allocator.ReservedSlots;
import org.apache.flink.runtime.scheduler.adaptive.allocator.SlotAllocator;
import org.apache.flink.runtime.scheduler.adaptive.allocator.VertexParallelism;
import org.apache.flink.runtime.util.ResourceCounter;
import org.apache.flink.util.function.TriFunction;

public class TestingSlotAllocator
implements SlotAllocator {
    private final Function<Iterable<JobInformation.VertexInformation>, ResourceCounter> calculateRequiredSlotsFunction;
    private final Function<JobSchedulingPlan, Optional<ReservedSlots>> tryReserveResourcesFunction;
    private final BiFunction<JobInformation, Collection<? extends SlotInfo>, Optional<VertexParallelism>> determineParallelismFunction;
    private final TriFunction<JobInformation, Collection<? extends SlotInfo>, JobAllocationsInformation, Optional<JobSchedulingPlan>> determineParallelismAndCalculateAssignmentFunction;

    private TestingSlotAllocator(Function<Iterable<JobInformation.VertexInformation>, ResourceCounter> calculateRequiredSlotsFunction, Function<JobSchedulingPlan, Optional<ReservedSlots>> tryReserveResourcesFunction, BiFunction<JobInformation, Collection<? extends SlotInfo>, Optional<VertexParallelism>> determineParallelismFunction, TriFunction<JobInformation, Collection<? extends SlotInfo>, JobAllocationsInformation, Optional<JobSchedulingPlan>> determineParallelismAndCalculateAssignmentFunction) {
        this.calculateRequiredSlotsFunction = calculateRequiredSlotsFunction;
        this.tryReserveResourcesFunction = tryReserveResourcesFunction;
        this.determineParallelismFunction = determineParallelismFunction;
        this.determineParallelismAndCalculateAssignmentFunction = determineParallelismAndCalculateAssignmentFunction;
    }

    public ResourceCounter calculateRequiredSlots(Iterable<JobInformation.VertexInformation> vertices) {
        return this.calculateRequiredSlotsFunction.apply(vertices);
    }

    public Optional<VertexParallelism> determineParallelism(JobInformation jobInformation, Collection<? extends SlotInfo> slots) {
        return this.determineParallelismFunction.apply(jobInformation, slots);
    }

    public Optional<JobSchedulingPlan> determineParallelismAndCalculateAssignment(JobInformation jobInformation, Collection<? extends SlotInfo> slots, JobAllocationsInformation jobAllocationsInformation) {
        return (Optional)this.determineParallelismAndCalculateAssignmentFunction.apply((Object)jobInformation, slots, (Object)jobAllocationsInformation);
    }

    public Optional<ReservedSlots> tryReserveResources(JobSchedulingPlan jobSchedulingPlan) {
        return this.tryReserveResourcesFunction.apply(jobSchedulingPlan);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static TestingSlotAllocator getArgumentCapturingDelegatingSlotAllocator(SlotAllocator slotAllocator, List<JobAllocationsInformation> capturedAllocations) {
        return TestingSlotAllocator.newBuilder().setCalculateRequiredSlotsFunction(arg_0 -> ((SlotAllocator)slotAllocator).calculateRequiredSlots(arg_0)).setTryReserveResourcesFunction(arg_0 -> ((SlotAllocator)slotAllocator).tryReserveResources(arg_0)).setDetermineParallelismFunction((arg_0, arg_1) -> ((SlotAllocator)slotAllocator).determineParallelism(arg_0, arg_1)).setDetermineParallelismAndCalculateAssignmentFunction((TriFunction<JobInformation, Collection<? extends SlotInfo>, JobAllocationsInformation, Optional<JobSchedulingPlan>>)((TriFunction)(jobInformation, slotInfos, jobAllocationsInformation) -> {
            capturedAllocations.add((JobAllocationsInformation)jobAllocationsInformation);
            return slotAllocator.determineParallelismAndCalculateAssignment(jobInformation, slotInfos, jobAllocationsInformation);
        })).build();
    }

    public static final class Builder {
        private Function<Iterable<JobInformation.VertexInformation>, ResourceCounter> calculateRequiredSlotsFunction = ignored -> ResourceCounter.empty();
        private Function<JobSchedulingPlan, Optional<ReservedSlots>> tryReserveResourcesFunction = ignored -> Optional.empty();
        private BiFunction<JobInformation, Collection<? extends SlotInfo>, Optional<VertexParallelism>> determineSlotsFunction = (jobInformation, slots) -> Optional.empty();
        private TriFunction<JobInformation, Collection<? extends SlotInfo>, JobAllocationsInformation, Optional<JobSchedulingPlan>> determineParallelismAndCalculateAssignmentFunction = (jobInformation, slots, jobAllocationsInformation) -> Optional.empty();

        public Builder setCalculateRequiredSlotsFunction(Function<Iterable<JobInformation.VertexInformation>, ResourceCounter> calculateRequiredSlotsFunction) {
            this.calculateRequiredSlotsFunction = calculateRequiredSlotsFunction;
            return this;
        }

        public Builder setDetermineParallelismFunction(BiFunction<JobInformation, Collection<? extends SlotInfo>, Optional<VertexParallelism>> determineParallelismFunction) {
            this.determineSlotsFunction = determineParallelismFunction;
            return this;
        }

        public Builder setDetermineParallelismAndCalculateAssignmentFunction(TriFunction<JobInformation, Collection<? extends SlotInfo>, JobAllocationsInformation, Optional<JobSchedulingPlan>> determineParallelismAndCalculateAssignmentFunction) {
            this.determineParallelismAndCalculateAssignmentFunction = determineParallelismAndCalculateAssignmentFunction;
            return this;
        }

        public Builder setTryReserveResourcesFunction(Function<JobSchedulingPlan, Optional<ReservedSlots>> tryReserveResourcesFunction) {
            this.tryReserveResourcesFunction = tryReserveResourcesFunction;
            return this;
        }

        public TestingSlotAllocator build() {
            return new TestingSlotAllocator(this.calculateRequiredSlotsFunction, this.tryReserveResourcesFunction, this.determineSlotsFunction, this.determineParallelismAndCalculateAssignmentFunction);
        }
    }
}

