/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc;

import java.util.function.Supplier;
import org.apache.flink.runtime.rpc.RpcGateway;

public class TestingRpcGateway
implements RpcGateway {
    private final Supplier<String> addressSupplier;
    private final Supplier<String> hostnameSupplier;

    private TestingRpcGateway(Supplier<String> addressSupplier, Supplier<String> hostnameSupplier) {
        this.addressSupplier = addressSupplier;
        this.hostnameSupplier = hostnameSupplier;
    }

    public String getAddress() {
        return this.addressSupplier.get();
    }

    public String getHostname() {
        return this.hostnameSupplier.get();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Supplier<String> addressSupplier = () -> "address";
        private Supplier<String> hostnameSupplier = () -> "hostname";

        private Builder() {
        }

        public Builder setAddressSupplier(Supplier<String> addressSupplier) {
            this.addressSupplier = addressSupplier;
            return this;
        }

        public Builder setHostnameSupplier(Supplier<String> hostnameSupplier) {
            this.hostnameSupplier = hostnameSupplier;
            return this;
        }

        public TestingRpcGateway build() {
            return new TestingRpcGateway(this.addressSupplier, this.hostnameSupplier);
        }
    }
}

