/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.async;

import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.runtime.rest.handler.async.CompletedOperationCache;
import org.apache.flink.runtime.rest.handler.async.OperationKey;
import org.apache.flink.runtime.rest.handler.async.OperationResult;
import org.apache.flink.runtime.rest.handler.async.OperationResultStatus;
import org.apache.flink.runtime.rest.messages.TriggerId;
import org.apache.flink.runtime.util.ManualTicker;
import org.apache.flink.shaded.guava32.com.google.common.base.Ticker;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class CompletedOperationCacheTest {
    private static final OperationKey TEST_OPERATION_KEY = new OperationKey(new TriggerId());
    private static final CompletableFuture<String> TEST_OPERATION_RESULT = CompletableFuture.completedFuture("foo");
    private ManualTicker manualTicker;
    private CompletedOperationCache<OperationKey, String> completedOperationCache;

    CompletedOperationCacheTest() {
    }

    @BeforeEach
    void setUp() {
        this.manualTicker = new ManualTicker();
        this.completedOperationCache = new CompletedOperationCache((Ticker)this.manualTicker);
    }

    @Test
    void testShouldFinishClosingCacheIfAllResultsAreEvicted() {
        this.completedOperationCache.registerOngoingOperation(TEST_OPERATION_KEY, TEST_OPERATION_RESULT);
        CompletableFuture closeCacheFuture = this.completedOperationCache.closeAsync();
        Assertions.assertThat((CompletableFuture)closeCacheFuture).isNotDone();
        this.manualTicker.advanceTime(300L, TimeUnit.SECONDS);
        this.completedOperationCache.cleanUp();
        Assertions.assertThat((CompletableFuture)closeCacheFuture).isDone();
    }

    @Test
    void testShouldFinishClosingCacheIfAllResultsAccessed() throws Exception {
        this.completedOperationCache.registerOngoingOperation(TEST_OPERATION_KEY, TEST_OPERATION_RESULT);
        CompletableFuture closeCacheFuture = this.completedOperationCache.closeAsync();
        Assertions.assertThat((CompletableFuture)closeCacheFuture).isNotDone();
        Optional operationResultOptional = this.completedOperationCache.get(TEST_OPERATION_KEY);
        Assertions.assertThat((Optional)operationResultOptional).isPresent();
        OperationResult operationResult = (OperationResult)operationResultOptional.get();
        Assertions.assertThat((Comparable)OperationResultStatus.SUCCESS).isEqualTo((Object)operationResult.getStatus());
        Assertions.assertThat((String)((String)operationResult.getResult())).isEqualTo(TEST_OPERATION_RESULT.get());
        Assertions.assertThat((CompletableFuture)closeCacheFuture).isDone();
    }

    @Test
    void testCannotAddOperationAfterClosing() {
        this.completedOperationCache.registerOngoingOperation(TEST_OPERATION_KEY, new CompletableFuture());
        CompletableFuture terminationFuture = this.completedOperationCache.closeAsync();
        Assertions.assertThat((CompletableFuture)terminationFuture).isNotDone();
        try {
            this.completedOperationCache.registerOngoingOperation(new OperationKey(new TriggerId()), new CompletableFuture());
            Assertions.fail((String)"It should no longer be possible to register new operations because the cache is shutting down.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    void testCanGetOperationResultAfterClosing() throws Exception {
        this.completedOperationCache.registerOngoingOperation(TEST_OPERATION_KEY, TEST_OPERATION_RESULT);
        this.completedOperationCache.closeAsync();
        Optional operationResultOptional = this.completedOperationCache.get(TEST_OPERATION_KEY);
        Assertions.assertThat((Optional)operationResultOptional).isPresent();
        OperationResult operationResult = (OperationResult)operationResultOptional.get();
        Assertions.assertThat((Comparable)OperationResultStatus.SUCCESS).isEqualTo((Object)operationResult.getStatus());
        Assertions.assertThat((String)((String)operationResult.getResult())).isEqualTo(TEST_OPERATION_RESULT.get());
    }

    @Test
    void testCacheTimeout() throws Exception {
        Duration timeout = (Duration)RestOptions.ASYNC_OPERATION_STORE_DURATION.defaultValue();
        this.completedOperationCache = new CompletedOperationCache(timeout, (Ticker)this.manualTicker);
        this.completedOperationCache.registerOngoingOperation(TEST_OPERATION_KEY, TEST_OPERATION_RESULT);
        Assertions.assertThat((Optional)this.completedOperationCache.get(TEST_OPERATION_KEY)).isPresent();
        this.manualTicker.advanceTime(timeout.multipliedBy(2L).getSeconds(), TimeUnit.SECONDS);
        Assertions.assertThat((Optional)this.completedOperationCache.get(TEST_OPERATION_KEY)).isNotPresent();
    }

    @Test
    void testCacheTimeoutCanBeDisabled() throws Exception {
        this.completedOperationCache = new CompletedOperationCache(Duration.ofSeconds(0L), (Ticker)this.manualTicker);
        this.completedOperationCache.registerOngoingOperation(TEST_OPERATION_KEY, TEST_OPERATION_RESULT);
        this.manualTicker.advanceTime(365L, TimeUnit.DAYS);
        Assertions.assertThat((Optional)this.completedOperationCache.get(TEST_OPERATION_KEY)).isPresent();
    }

    @Test
    void testCacheTimeoutCanBeConfigured() throws Exception {
        Duration baseTimeout = (Duration)RestOptions.ASYNC_OPERATION_STORE_DURATION.defaultValue();
        this.completedOperationCache = new CompletedOperationCache(baseTimeout.multipliedBy(10L), (Ticker)this.manualTicker);
        this.completedOperationCache.registerOngoingOperation(TEST_OPERATION_KEY, TEST_OPERATION_RESULT);
        this.manualTicker.advanceTime(baseTimeout.multipliedBy(2L).getSeconds(), TimeUnit.SECONDS);
        Assertions.assertThat((Optional)this.completedOperationCache.get(TEST_OPERATION_KEY)).isPresent();
    }

    @Test
    void containsReturnsFalseForUnknownOperation() {
        Assertions.assertThat((boolean)this.completedOperationCache.containsOperation(TEST_OPERATION_KEY)).isFalse();
    }

    @Test
    void containsChecksOnoingOperations() {
        this.completedOperationCache.registerOngoingOperation(TEST_OPERATION_KEY, new CompletableFuture());
        Assertions.assertThat((boolean)this.completedOperationCache.containsOperation(TEST_OPERATION_KEY)).isTrue();
    }

    @Test
    void containsChecksCompletedOperations() {
        this.completedOperationCache.registerOngoingOperation(TEST_OPERATION_KEY, CompletableFuture.completedFuture(null));
        Assertions.assertThat((boolean)this.completedOperationCache.containsOperation(TEST_OPERATION_KEY)).isTrue();
    }

    @Test
    void containsDoesNotMarkResultAsAccessed() {
        this.completedOperationCache.registerOngoingOperation(TEST_OPERATION_KEY, CompletableFuture.completedFuture(null));
        Assertions.assertThat((boolean)this.completedOperationCache.containsOperation(TEST_OPERATION_KEY)).isTrue();
        FlinkAssertions.assertThatFuture((CompletableFuture)this.completedOperationCache.closeAsync()).willNotCompleteWithin(Duration.ofMillis(10L));
    }
}

