/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.time.Duration;
import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ResourceManagerOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerConfiguration;
import org.apache.flink.testutils.TestingUtils;

public class SlotManagerConfigurationBuilder {
    private Duration taskManagerRequestTimeout = TestingUtils.infiniteTime();
    private Duration taskManagerTimeout = TestingUtils.infiniteTime();
    private Duration requirementCheckDelay = (Duration)ResourceManagerOptions.REQUIREMENTS_CHECK_DELAY.defaultValue();
    private Duration declareNeededResourceDelay = (Duration)ResourceManagerOptions.DECLARE_NEEDED_RESOURCE_DELAY.defaultValue();
    private boolean waitResultConsumedBeforeRelease = true;
    private WorkerResourceSpec defaultWorkerResourceSpec = WorkerResourceSpec.ZERO;
    private int numSlotsPerWorker = 1;
    private int minSlotNum = (Integer)ResourceManagerOptions.MIN_SLOT_NUM.defaultValue();
    private int maxSlotNum = (Integer)ResourceManagerOptions.MAX_SLOT_NUM.defaultValue();
    private CPUResource minTotalCpu = new CPUResource(Double.MIN_VALUE);
    private CPUResource maxTotalCpu = new CPUResource(Double.MAX_VALUE);
    private MemorySize minTotalMem = MemorySize.ZERO;
    private MemorySize maxTotalMem = MemorySize.MAX_VALUE;
    private int redundantTaskManagerNum = (Integer)ResourceManagerOptions.REDUNDANT_TASK_MANAGER_NUM.defaultValue();
    private TaskManagerOptions.TaskManagerLoadBalanceMode taskManagerLoadBalanceMode = TaskManagerOptions.TaskManagerLoadBalanceMode.NONE;

    private SlotManagerConfigurationBuilder() {
    }

    public static SlotManagerConfigurationBuilder newBuilder() {
        return new SlotManagerConfigurationBuilder();
    }

    public SlotManagerConfigurationBuilder setTaskManagerRequestTimeout(Duration taskManagerRequestTimeout) {
        this.taskManagerRequestTimeout = taskManagerRequestTimeout;
        return this;
    }

    public SlotManagerConfigurationBuilder setTaskManagerTimeout(Duration taskManagerTimeout) {
        this.taskManagerTimeout = taskManagerTimeout;
        return this;
    }

    public SlotManagerConfigurationBuilder setRequirementCheckDelay(Duration requirementCheckDelay) {
        this.requirementCheckDelay = requirementCheckDelay;
        return this;
    }

    public SlotManagerConfigurationBuilder setDeclareNeededResourceDelay(Duration declareNeededResourceDelay) {
        this.declareNeededResourceDelay = declareNeededResourceDelay;
        return this;
    }

    public SlotManagerConfigurationBuilder setWaitResultConsumedBeforeRelease(boolean waitResultConsumedBeforeRelease) {
        this.waitResultConsumedBeforeRelease = waitResultConsumedBeforeRelease;
        return this;
    }

    public SlotManagerConfigurationBuilder setDefaultWorkerResourceSpec(WorkerResourceSpec defaultWorkerResourceSpec) {
        this.defaultWorkerResourceSpec = defaultWorkerResourceSpec;
        return this;
    }

    public SlotManagerConfigurationBuilder setNumSlotsPerWorker(int numSlotsPerWorker) {
        this.numSlotsPerWorker = numSlotsPerWorker;
        return this;
    }

    public void setMinSlotNum(int minSlotNum) {
        this.minSlotNum = minSlotNum;
    }

    public SlotManagerConfigurationBuilder setMaxSlotNum(int maxSlotNum) {
        this.maxSlotNum = maxSlotNum;
        return this;
    }

    public void setMinTotalCpu(CPUResource minTotalCpu) {
        this.minTotalCpu = minTotalCpu;
    }

    public SlotManagerConfigurationBuilder setMaxTotalCpu(CPUResource maxTotalCpu) {
        this.maxTotalCpu = maxTotalCpu;
        return this;
    }

    public void setMinTotalMem(MemorySize minTotalMem) {
        this.minTotalMem = minTotalMem;
    }

    public SlotManagerConfigurationBuilder setMaxTotalMem(MemorySize maxTotalMem) {
        this.maxTotalMem = maxTotalMem;
        return this;
    }

    public SlotManagerConfigurationBuilder setRedundantTaskManagerNum(int redundantTaskManagerNum) {
        this.redundantTaskManagerNum = redundantTaskManagerNum;
        return this;
    }

    public SlotManagerConfigurationBuilder setTaskManagerLoadBalanceMode(TaskManagerOptions.TaskManagerLoadBalanceMode taskManagerLoadBalanceMode) {
        this.taskManagerLoadBalanceMode = taskManagerLoadBalanceMode;
        return this;
    }

    public SlotManagerConfiguration build() {
        return new SlotManagerConfiguration(this.taskManagerRequestTimeout, this.taskManagerTimeout, this.requirementCheckDelay, this.declareNeededResourceDelay, this.taskManagerLoadBalanceMode, this.defaultWorkerResourceSpec, this.numSlotsPerWorker, this.minSlotNum, this.maxSlotNum, this.minTotalCpu, this.maxTotalCpu, this.minTotalMem, this.maxTotalMem, this.redundantTaskManagerNum);
    }
}

