/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.util;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MeterView;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.memory.MemoryAllocationException;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.metrics.util.InterceptingOperatorMetricGroup;
import org.apache.flink.runtime.metrics.util.MetricUtils;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcSystem;
import org.apache.flink.runtime.taskexecutor.TaskManagerServices;
import org.apache.flink.runtime.taskexecutor.TaskManagerServicesBuilder;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotTable;
import org.apache.flink.runtime.taskexecutor.slot.TestingTaskSlotTable;
import org.apache.flink.shaded.guava32.com.google.common.collect.Sets;
import org.apache.flink.testutils.ClassLoaderUtils;
import org.apache.flink.util.ChildFirstClassLoader;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.function.CheckedSupplier;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

class MetricUtilsTest {
    private final List<Object> referencedObjects = new ArrayList<Object>();

    MetricUtilsTest() {
    }

    @AfterEach
    void cleanupReferencedObjects() {
        this.referencedObjects.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testStartMetricActorSystemRespectsThreadPriority() throws Exception {
        Configuration configuration = new Configuration();
        int expectedThreadPriority = 3;
        configuration.set(MetricOptions.QUERY_SERVICE_THREAD_PRIORITY, (Object)3);
        RpcService rpcService = MetricUtils.startRemoteMetricsRpcService((Configuration)configuration, (String)"localhost", null, (RpcSystem)RpcSystem.load());
        try {
            int threadPriority = (Integer)rpcService.getScheduledExecutor().schedule(() -> Thread.currentThread().getPriority(), 0L, TimeUnit.SECONDS).get();
            Assertions.assertThat((int)threadPriority).isEqualTo(3);
        }
        finally {
            rpcService.closeAsync().get();
        }
    }

    @Test
    void testNonHeapMetricsCompleteness() {
        InterceptingOperatorMetricGroup nonHeapMetrics = new InterceptingOperatorMetricGroup();
        MetricUtils.instantiateNonHeapMemoryMetrics((MetricGroup)nonHeapMetrics);
        Assertions.assertThat((Object)nonHeapMetrics.get("Used")).isNotNull();
        Assertions.assertThat((Object)nonHeapMetrics.get("Committed")).isNotNull();
        Assertions.assertThat((Object)nonHeapMetrics.get("Max")).isNotNull();
    }

    @Test
    void testMetaspaceCompleteness() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)MetricUtilsTest.hasMetaspaceMemoryPool()).withFailMessage("Requires JVM with Metaspace memory pool", new Object[0])).isTrue();
        InterceptingOperatorMetricGroup metaspaceMetrics = new InterceptingOperatorMetricGroup(){

            public MetricGroup addGroup(String name) {
                return this;
            }
        };
        MetricUtils.instantiateMetaspaceMemoryMetrics((MetricGroup)metaspaceMetrics);
        Assertions.assertThat((Object)metaspaceMetrics.get("Used")).isNotNull();
        Assertions.assertThat((Object)metaspaceMetrics.get("Committed")).isNotNull();
        Assertions.assertThat((Object)metaspaceMetrics.get("Max")).isNotNull();
    }

    @Test
    public void testGcMetricCompleteness() {
        final HashMap addedGroups = new HashMap();
        InterceptingOperatorMetricGroup gcGroup = new InterceptingOperatorMetricGroup(){

            public MetricGroup addGroup(String name) {
                return (MetricGroup)addedGroups.computeIfAbsent(name, k -> new InterceptingOperatorMetricGroup());
            }
        };
        ArrayList<TestGcBean> garbageCollectors = new ArrayList<TestGcBean>();
        garbageCollectors.add(new TestGcBean("gc1", 100L, 500L));
        garbageCollectors.add(new TestGcBean("gc2", 50L, 250L));
        MetricUtils.instantiateGarbageCollectorMetrics((MetricGroup)gcGroup, garbageCollectors);
        Assertions.assertThat(addedGroups).containsOnlyKeys((Object[])new String[]{"gc1", "gc2", "All"});
        MetricUtilsTest.validateCollectorMetric((InterceptingOperatorMetricGroup)((Object)addedGroups.get("gc1")), 100L, 500L);
        MetricUtilsTest.validateCollectorMetric((InterceptingOperatorMetricGroup)((Object)addedGroups.get("gc2")), 50L, 250L);
        MetricUtilsTest.validateCollectorMetric((InterceptingOperatorMetricGroup)((Object)addedGroups.get("All")), 150L, 750L);
    }

    private static void validateCollectorMetric(InterceptingOperatorMetricGroup group, long count, long time) {
        Assertions.assertThat((Object)((Gauge)group.get("Count")).getValue()).isEqualTo((Object)count);
        Assertions.assertThat((Object)((Gauge)group.get("Time")).getValue()).isEqualTo((Object)time);
        MeterView perSecond = (MeterView)group.get("TimeMsPerSecond");
        perSecond.update();
        Assertions.assertThat((double)perSecond.getRate()).isGreaterThan(0.0);
    }

    @Test
    void testHeapMetricsCompleteness() {
        InterceptingOperatorMetricGroup heapMetrics = new InterceptingOperatorMetricGroup();
        MetricUtils.instantiateHeapMemoryMetrics((MetricGroup)heapMetrics);
        Assertions.assertThat((Object)heapMetrics.get("Used")).isNotNull();
        Assertions.assertThat((Object)heapMetrics.get("Committed")).isNotNull();
        Assertions.assertThat((Object)heapMetrics.get("Max")).isNotNull();
    }

    @Test
    void testHeapMetricUsageNotStatic() throws Exception {
        InterceptingOperatorMetricGroup heapMetrics = new InterceptingOperatorMetricGroup();
        MetricUtils.instantiateHeapMemoryMetrics((MetricGroup)heapMetrics);
        Gauge used = (Gauge)heapMetrics.get("Used");
        this.runUntilMetricChanged("Heap", 10, (CheckedSupplier<Object>)((CheckedSupplier)() -> new byte[0x800000]), (Gauge<Long>)used);
    }

    @Test
    void testMetaspaceMetricUsageNotStatic() throws Exception {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)MetricUtilsTest.hasMetaspaceMemoryPool()).withFailMessage("Requires JVM with Metaspace memory pool", new Object[0])).isTrue();
        InterceptingOperatorMetricGroup metaspaceMetrics = new InterceptingOperatorMetricGroup(){

            public MetricGroup addGroup(String name) {
                return this;
            }
        };
        MetricUtils.instantiateMetaspaceMemoryMetrics((MetricGroup)metaspaceMetrics);
        Gauge used = (Gauge)metaspaceMetrics.get("Used");
        this.runUntilMetricChanged("Metaspace", 10, (CheckedSupplier<Object>)((CheckedSupplier)MetricUtilsTest::redefineDummyClass), (Gauge<Long>)used);
    }

    @Test
    void testNonHeapMetricUsageNotStatic() throws Exception {
        InterceptingOperatorMetricGroup nonHeapMetrics = new InterceptingOperatorMetricGroup();
        MetricUtils.instantiateNonHeapMemoryMetrics((MetricGroup)nonHeapMetrics);
        Gauge used = (Gauge)nonHeapMetrics.get("Used");
        this.runUntilMetricChanged("Non-heap", 10, (CheckedSupplier<Object>)((CheckedSupplier)MetricUtilsTest::redefineDummyClass), (Gauge<Long>)used);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testManagedMemoryMetricsInitialization() throws MemoryAllocationException, FlinkException {
        int maxMemorySize = 16284;
        int numberOfAllocatedPages = 2;
        int pageSize = 4096;
        Object owner = new Object();
        MemoryManager memoryManager = MemoryManager.create((long)16284L, (int)4096);
        memoryManager.allocatePages(owner, 2);
        TaskManagerServices taskManagerServices = new TaskManagerServicesBuilder().setTaskSlotTable(new TestingTaskSlotTable.TestingTaskSlotTableBuilder().memoryManagerGetterReturns(memoryManager).allActiveSlotAllocationIds(() -> Sets.newHashSet((Object[])new AllocationID[]{new AllocationID()})).build()).setManagedMemorySize(16284L).build();
        try {
            final ArrayList actualSubGroupPath = new ArrayList();
            InterceptingOperatorMetricGroup metricGroup = new InterceptingOperatorMetricGroup(){

                public MetricGroup addGroup(String name) {
                    actualSubGroupPath.add(name);
                    return this;
                }
            };
            MetricUtils.instantiateFlinkMemoryMetricGroup((MetricGroup)metricGroup, (TaskSlotTable)taskManagerServices.getTaskSlotTable(), () -> ((TaskManagerServices)taskManagerServices).getManagedMemorySize());
            Gauge usedMetric = (Gauge)metricGroup.get("Used");
            Gauge maxMetric = (Gauge)metricGroup.get("Total");
            Assertions.assertThat((int)((Number)usedMetric.getValue()).intValue()).isEqualTo(8192);
            Assertions.assertThat((int)((Number)maxMetric.getValue()).intValue()).isEqualTo(16284);
            Assertions.assertThat(actualSubGroupPath).containsAnyElementsOf(Arrays.asList("Flink", "Memory", "Managed"));
        }
        finally {
            taskManagerServices.shutDown();
        }
    }

    @Test
    void testTruncateOperatorName() {
        Assertions.assertThat((String)MetricUtils.truncateOperatorName(null)).isNull();
        String operatorNameLess = "testOperatorName";
        Assertions.assertThat((String)MetricUtils.truncateOperatorName((String)"testOperatorName")).isEqualTo("testOperatorName");
        String operatorNameLessEndWithWriter = "testOperatorName: Writer";
        Assertions.assertThat((String)MetricUtils.truncateOperatorName((String)"testOperatorName: Writer")).isEqualTo("testOperatorName: Writer");
        String operatorNameLessEndWithCommitter = "testOperatorName: Committer";
        Assertions.assertThat((String)MetricUtils.truncateOperatorName((String)"testOperatorName: Committer")).isEqualTo("testOperatorName: Committer");
        String operatorNameLessAndContainsWriter = "test: WriterOperatorName";
        Assertions.assertThat((String)MetricUtils.truncateOperatorName((String)"test: WriterOperatorName")).isEqualTo("test: WriterOperatorName");
        String operatorNameLessAndContainsCommitter = "test: CommitterOperatorName";
        Assertions.assertThat((String)MetricUtils.truncateOperatorName((String)"test: CommitterOperatorName")).isEqualTo("test: CommitterOperatorName");
        String operatorNameMore = "testLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongOperatorName";
        String expectedOperatorNameMore = "testLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLong";
        Assertions.assertThat((String)MetricUtils.truncateOperatorName((String)"testLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongOperatorName")).isEqualTo("testLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLong");
        String operatorNameMoreEndWithWriter = "testLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongOperatorName: Writer";
        String expectedOperatorNameMoreEndWithWriter = "testLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLong: Writer";
        Assertions.assertThat((String)MetricUtils.truncateOperatorName((String)"testLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongOperatorName: Writer")).isEqualTo("testLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLong: Writer");
        String operatorNameMoreEndWithCommitter = "testLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongOperatorName: Committer";
        String expectedOperatorNameMoreEndWithCommitter = "testLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongL: Committer";
        Assertions.assertThat((String)MetricUtils.truncateOperatorName((String)"testLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongOperatorName: Committer")).isEqualTo("testLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongL: Committer");
        String operatorNameMoreAndContainsWriter = "testLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLong: WriterOperatorName";
        Assertions.assertThat((String)MetricUtils.truncateOperatorName((String)"testLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLong: WriterOperatorName")).isEqualTo("testLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLong");
        String operatorNameMoreAndContainsCommitter = "testLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLong: CommitterOperatorName";
        Assertions.assertThat((String)MetricUtils.truncateOperatorName((String)"testLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLong: CommitterOperatorName")).isEqualTo("testLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLong");
    }

    private static Class<?> redefineDummyClass() throws ClassNotFoundException {
        Class<Dummy> clazz = Dummy.class;
        ChildFirstClassLoader classLoader = new ChildFirstClassLoader(ClassLoaderUtils.getClasspathURLs(), clazz.getClassLoader(), new String[]{"java."}, ignored -> {});
        Class newClass = classLoader.loadClass(clazz.getName());
        Assertions.assertThat((Class)newClass).isNotSameAs(clazz);
        Assertions.assertThat((String)newClass.getName()).isEqualTo(clazz.getName());
        return newClass;
    }

    private static boolean hasMetaspaceMemoryPool() {
        return ManagementFactory.getMemoryPoolMXBeans().stream().anyMatch(bean -> "Metaspace".equals(bean.getName()));
    }

    private void runUntilMetricChanged(String name, int maxRuns, CheckedSupplier<Object> objectCreator, Gauge<Long> metric) throws Exception {
        maxRuns = Math.max(1, maxRuns);
        long initialValue = (Long)metric.getValue();
        for (int i = 0; i < maxRuns; ++i) {
            Object object = objectCreator.get();
            long currentValue = (Long)metric.getValue();
            if (currentValue != initialValue) {
                return;
            }
            this.referencedObjects.add(object);
            Thread.sleep(50L);
        }
        String msg = String.format("%s usage metric never changed its value after %d runs.", name, maxRuns);
        Assertions.fail((String)msg);
    }

    static class TestGcBean
    implements GarbageCollectorMXBean {
        final String name;
        final long collectionCount;
        final long collectionTime;

        public TestGcBean(String name, long collectionCount, long collectionTime) {
            this.name = name;
            this.collectionCount = collectionCount;
            this.collectionTime = collectionTime;
        }

        @Override
        public long getCollectionCount() {
            return this.collectionCount;
        }

        @Override
        public long getCollectionTime() {
            return this.collectionTime;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isValid() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getMemoryPoolNames() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectName getObjectName() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Dummy {
        private Dummy() {
        }
    }
}

