/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.filter;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.regex.Pattern;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricType;
import org.apache.flink.metrics.util.TestCounter;
import org.apache.flink.metrics.util.TestMeter;
import org.apache.flink.runtime.metrics.filter.DefaultMetricFilter;
import org.apache.flink.runtime.metrics.filter.MetricFilter;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.CONCURRENT)
class DefaultMetricFilterTest {
    private static final Counter COUNTER = new TestCounter();
    private static final Meter METER = new TestMeter();
    private static final Gauge<Integer> GAUGE = () -> 4;

    DefaultMetricFilterTest() {
    }

    @Test
    void testConvertToPatternWithoutWildcards() {
        Pattern pattern = DefaultMetricFilter.convertToPattern((String)"numRecordsIn");
        Assertions.assertThat((String)pattern.toString()).isEqualTo("(numRecordsIn)");
        Assertions.assertThat((boolean)pattern.matcher("numRecordsIn").matches()).isTrue();
        Assertions.assertThat((boolean)pattern.matcher("numBytesOut").matches()).isFalse();
    }

    @Test
    void testConvertToPatternSingle() {
        Pattern pattern = DefaultMetricFilter.convertToPattern((String)"numRecords*");
        Assertions.assertThat((String)pattern.toString()).isEqualTo("(numRecords.*)");
        Assertions.assertThat((boolean)pattern.matcher("numRecordsIn").matches()).isTrue();
        Assertions.assertThat((boolean)pattern.matcher("numBytesOut").matches()).isFalse();
    }

    @Test
    void testConvertToPatternMultiple() {
        Pattern pattern = DefaultMetricFilter.convertToPattern((String)"numRecords*,numBytes*");
        Assertions.assertThat((String)pattern.toString()).isEqualTo("(numRecords.*|numBytes.*)");
        Assertions.assertThat((boolean)pattern.matcher("numRecordsIn").matches()).isTrue();
        Assertions.assertThat((boolean)pattern.matcher("numBytesOut").matches()).isTrue();
        Assertions.assertThat((boolean)pattern.matcher("numBytes").matches()).isTrue();
        Assertions.assertThat((boolean)pattern.matcher("hello").matches()).isFalse();
    }

    @Test
    void testParseMetricTypesSingle() {
        EnumSet types = DefaultMetricFilter.parseMetricTypes((String)"meter");
        Assertions.assertThat((Collection)types).containsExactly((Object[])new MetricType[]{MetricType.METER});
    }

    @Test
    void testParseMetricTypesMultiple() {
        EnumSet types = DefaultMetricFilter.parseMetricTypes((String)"meter,counter");
        Assertions.assertThat((Collection)types).containsExactlyInAnyOrder((Object[])new MetricType[]{MetricType.METER, MetricType.COUNTER});
    }

    @Test
    void testParseMetricTypesCaseIgnored() {
        EnumSet types = DefaultMetricFilter.parseMetricTypes((String)"meter,CoUnTeR");
        Assertions.assertThat((Collection)types).containsExactlyInAnyOrder((Object[])new MetricType[]{MetricType.METER, MetricType.COUNTER});
    }

    @Test
    void testFromConfigurationIncludeByScope() {
        Configuration configuration = new Configuration();
        configuration.set(MetricOptions.REPORTER_INCLUDES, Arrays.asList("include1:*:*", "include2.*:*:*"));
        configuration.set(MetricOptions.REPORTER_EXCLUDES, Collections.emptyList());
        MetricFilter metricFilter = DefaultMetricFilter.fromConfiguration((Configuration)configuration);
        Assertions.assertThat((boolean)metricFilter.filter((Metric)COUNTER, "name", "include1")).isTrue();
        Assertions.assertThat((boolean)metricFilter.filter((Metric)COUNTER, "name", "include1.bar")).isFalse();
        Assertions.assertThat((boolean)metricFilter.filter((Metric)COUNTER, "name", "include2")).isFalse();
        Assertions.assertThat((boolean)metricFilter.filter((Metric)COUNTER, "name", "include2.bar")).isTrue();
    }

    @Test
    void testFromConfigurationIncludeByName() {
        Configuration configuration = new Configuration();
        configuration.set(MetricOptions.REPORTER_INCLUDES, Arrays.asList("*:name:*"));
        configuration.set(MetricOptions.REPORTER_EXCLUDES, Collections.emptyList());
        MetricFilter metricFilter = DefaultMetricFilter.fromConfiguration((Configuration)configuration);
        Assertions.assertThat((boolean)metricFilter.filter((Metric)COUNTER, "name", "bar")).isTrue();
        Assertions.assertThat((boolean)metricFilter.filter((Metric)COUNTER, "foo", "bar")).isFalse();
    }

    @Test
    void testFromConfigurationIncludeByType() {
        Configuration configuration = new Configuration();
        configuration.set(MetricOptions.REPORTER_INCLUDES, Arrays.asList("*:*:counter"));
        configuration.set(MetricOptions.REPORTER_EXCLUDES, Collections.emptyList());
        MetricFilter metricFilter = DefaultMetricFilter.fromConfiguration((Configuration)configuration);
        Assertions.assertThat((boolean)metricFilter.filter((Metric)COUNTER, "foo", "bar")).isTrue();
        Assertions.assertThat((boolean)metricFilter.filter((Metric)METER, "foo", "bar")).isFalse();
    }

    @Test
    void testFromConfigurationExcludeByScope() {
        Configuration configuration = new Configuration();
        configuration.set(MetricOptions.REPORTER_INCLUDES, Arrays.asList("*:*:*"));
        configuration.set(MetricOptions.REPORTER_EXCLUDES, Arrays.asList("include1", "include2.*"));
        MetricFilter metricFilter = DefaultMetricFilter.fromConfiguration((Configuration)configuration);
        Assertions.assertThat((boolean)metricFilter.filter((Metric)COUNTER, "name", "include1")).isFalse();
        Assertions.assertThat((boolean)metricFilter.filter((Metric)COUNTER, "name", "include1.bar")).isTrue();
        Assertions.assertThat((boolean)metricFilter.filter((Metric)COUNTER, "name", "include2")).isTrue();
        Assertions.assertThat((boolean)metricFilter.filter((Metric)COUNTER, "name", "include2.bar")).isFalse();
    }

    @Test
    void testFromConfigurationExcludeByName() {
        Configuration configuration = new Configuration();
        configuration.set(MetricOptions.REPORTER_INCLUDES, Arrays.asList("*:*:*"));
        configuration.set(MetricOptions.REPORTER_EXCLUDES, Arrays.asList("*:faa*", "*:foo"));
        MetricFilter metricFilter = DefaultMetricFilter.fromConfiguration((Configuration)configuration);
        Assertions.assertThat((boolean)metricFilter.filter((Metric)COUNTER, "name", "bar")).isTrue();
        Assertions.assertThat((boolean)metricFilter.filter((Metric)COUNTER, "foo", "bar")).isFalse();
        Assertions.assertThat((boolean)metricFilter.filter((Metric)COUNTER, "foob", "bar")).isTrue();
        Assertions.assertThat((boolean)metricFilter.filter((Metric)COUNTER, "faab", "bar")).isFalse();
    }

    @Test
    void testFromConfigurationExcludeByType() {
        Configuration configuration = new Configuration();
        configuration.set(MetricOptions.REPORTER_INCLUDES, Arrays.asList("*:*:*"));
        configuration.set(MetricOptions.REPORTER_EXCLUDES, Arrays.asList("*:*:meter"));
        MetricFilter metricFilter = DefaultMetricFilter.fromConfiguration((Configuration)configuration);
        Assertions.assertThat((boolean)metricFilter.filter((Metric)COUNTER, "foo", "bar")).isTrue();
        Assertions.assertThat((boolean)metricFilter.filter((Metric)METER, "foo", "bar")).isFalse();
    }

    @Test
    void testFromConfigurationIncludeDefault() {
        Configuration configuration = new Configuration();
        configuration.set(MetricOptions.REPORTER_EXCLUDES, Arrays.asList("*:*:meter"));
        MetricFilter metricFilter = DefaultMetricFilter.fromConfiguration((Configuration)configuration);
        Assertions.assertThat((boolean)metricFilter.filter((Metric)COUNTER, "foo", "hello")).isTrue();
        Assertions.assertThat((boolean)metricFilter.filter((Metric)METER, "foo", "hello")).isFalse();
    }

    @Test
    void testFromConfigurationExcludeDefault() {
        Configuration configuration = new Configuration();
        configuration.set(MetricOptions.REPORTER_INCLUDES, Arrays.asList("*:*:*"));
        MetricFilter metricFilter = DefaultMetricFilter.fromConfiguration((Configuration)configuration);
        Assertions.assertThat((boolean)metricFilter.filter((Metric)COUNTER, "foo", "bar")).isTrue();
    }

    @Test
    void testFromConfigurationAllDefault() {
        Configuration configuration = new Configuration();
        MetricFilter metricFilter = DefaultMetricFilter.fromConfiguration((Configuration)configuration);
        Assertions.assertThat((boolean)metricFilter.filter((Metric)COUNTER, "foo", "bar")).isTrue();
        Assertions.assertThat((boolean)metricFilter.filter((Metric)METER, "foo", "bar")).isTrue();
    }

    @Test
    void testFromConfigurationMultiplePatterns() {
        Configuration configuration = new Configuration();
        configuration.set(MetricOptions.REPORTER_EXCLUDES, Arrays.asList("*:*:*"));
        configuration.setString(MetricOptions.REPORTER_EXCLUDES.key(), "*:foo,bar:meter;*:foo,bar:gauge");
        MetricFilter metricFilter = DefaultMetricFilter.fromConfiguration((Configuration)configuration);
        Assertions.assertThat((boolean)metricFilter.filter((Metric)COUNTER, "foo", "bar")).isTrue();
        Assertions.assertThat((boolean)metricFilter.filter((Metric)METER, "foo", "bar")).isFalse();
        Assertions.assertThat((boolean)metricFilter.filter(GAUGE, "foo", "bar")).isFalse();
    }
}

