/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.memory;

import org.apache.flink.runtime.memory.MemoryAllocationException;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.memory.MemoryManagerBuilder;
import org.apache.flink.runtime.memory.OpaqueMemoryResource;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MemoryManagerSharedResourcesTest {
    MemoryManagerSharedResourcesTest() {
    }

    @Test
    void getSameTypeGetsSameHandle() throws Exception {
        MemoryManager memoryManager = MemoryManagerSharedResourcesTest.createMemoryManager();
        OpaqueMemoryResource resource1 = memoryManager.getSharedMemoryResourceForManagedMemory("type", TestResource::new, 0.1);
        OpaqueMemoryResource resource2 = memoryManager.getSharedMemoryResourceForManagedMemory("type", TestResource::new, 0.1);
        Assertions.assertThat((Object)resource2).isNotSameAs((Object)resource1);
        Assertions.assertThat((Object)((TestResource)resource2.getResourceHandle())).isSameAs(resource1.getResourceHandle());
    }

    @Test
    void getDifferentTypeGetsDifferentResources() throws Exception {
        MemoryManager memoryManager = MemoryManagerSharedResourcesTest.createMemoryManager();
        OpaqueMemoryResource resource1 = memoryManager.getSharedMemoryResourceForManagedMemory("type1", TestResource::new, 0.1);
        OpaqueMemoryResource resource2 = memoryManager.getSharedMemoryResourceForManagedMemory("type2", TestResource::new, 0.1);
        Assertions.assertThat((Object)resource2).isNotSameAs((Object)resource1);
        Assertions.assertThat((Object)((TestResource)resource2.getResourceHandle())).isNotSameAs(resource1.getResourceHandle());
    }

    @Test
    void testAllocatesFractionOfTotalMemory() throws Exception {
        MemoryManager memoryManager = MemoryManagerSharedResourcesTest.createMemoryManager();
        double fraction = 0.2;
        OpaqueMemoryResource resource = memoryManager.getSharedMemoryResourceForManagedMemory("type", TestResource::new, 0.2);
        Assertions.assertThat((long)resource.getSize()).isEqualTo((long)(0.2 * (double)memoryManager.getMemorySize()));
    }

    @Test
    void getAllocateNewReservesMemory() throws Exception {
        MemoryManager memoryManager = MemoryManagerSharedResourcesTest.createMemoryManager();
        memoryManager.getSharedMemoryResourceForManagedMemory("type", TestResource::new, 0.5);
        Assertions.assertThat((long)memoryManager.availableMemory()).isEqualTo(memoryManager.getMemorySize() / 2L);
    }

    @Test
    void getExistingDoesNotAllocateAdditionalMemory() throws Exception {
        MemoryManager memoryManager = MemoryManagerSharedResourcesTest.createMemoryManager();
        memoryManager.getSharedMemoryResourceForManagedMemory("type", TestResource::new, 0.8);
        long freeMemory = memoryManager.availableMemory();
        memoryManager.getSharedMemoryResourceForManagedMemory("type", TestResource::new, 0.8);
        Assertions.assertThat((long)memoryManager.availableMemory()).isEqualTo(freeMemory);
    }

    @Test
    void testFailReservation() throws Exception {
        MemoryManager memoryManager = MemoryManagerSharedResourcesTest.createMemoryManager();
        memoryManager.getSharedMemoryResourceForManagedMemory("type", TestResource::new, 0.8);
        Assertions.assertThatExceptionOfType(MemoryAllocationException.class).isThrownBy(() -> memoryManager.getSharedMemoryResourceForManagedMemory("type2", TestResource::new, 0.8));
    }

    @Test
    void testPartialReleaseDoesNotReleaseMemory() throws Exception {
        MemoryManager memoryManager = MemoryManagerSharedResourcesTest.createMemoryManager();
        OpaqueMemoryResource resource1 = memoryManager.getSharedMemoryResourceForManagedMemory("type", TestResource::new, 0.1);
        memoryManager.getSharedMemoryResourceForManagedMemory("type", TestResource::new, 0.1);
        Assertions.assertThat((boolean)memoryManager.verifyEmpty()).isFalse();
        resource1.close();
        Assertions.assertThat((boolean)((TestResource)resource1.getResourceHandle()).closed).isFalse();
        Assertions.assertThat((boolean)memoryManager.verifyEmpty()).isFalse();
    }

    @Test
    void testLastReleaseReleasesMemory() throws Exception {
        MemoryManager memoryManager = MemoryManagerSharedResourcesTest.createMemoryManager();
        OpaqueMemoryResource resource1 = memoryManager.getSharedMemoryResourceForManagedMemory("type", TestResource::new, 0.1);
        OpaqueMemoryResource resource2 = memoryManager.getSharedMemoryResourceForManagedMemory("type", TestResource::new, 0.1);
        Assertions.assertThat((boolean)memoryManager.verifyEmpty()).isFalse();
        resource1.close();
        resource2.close();
        Assertions.assertThat((boolean)((TestResource)resource1.getResourceHandle()).closed).isTrue();
        Assertions.assertThat((boolean)memoryManager.verifyEmpty()).isTrue();
    }

    @Test
    void testPartialReleaseDoesNotDisposeResource() throws Exception {
        MemoryManager memoryManager = MemoryManagerSharedResourcesTest.createMemoryManager();
        OpaqueMemoryResource resource1 = memoryManager.getSharedMemoryResourceForManagedMemory("type", TestResource::new, 0.1);
        memoryManager.getSharedMemoryResourceForManagedMemory("type", TestResource::new, 0.1);
        resource1.close();
        Assertions.assertThat((boolean)((TestResource)resource1.getResourceHandle()).closed).isFalse();
        Assertions.assertThat((boolean)memoryManager.verifyEmpty()).isFalse();
    }

    @Test
    void testLastReleaseDisposesResource() throws Exception {
        MemoryManager memoryManager = MemoryManagerSharedResourcesTest.createMemoryManager();
        OpaqueMemoryResource resource1 = memoryManager.getSharedMemoryResourceForManagedMemory("type", TestResource::new, 0.1);
        OpaqueMemoryResource resource2 = memoryManager.getSharedMemoryResourceForManagedMemory("type", TestResource::new, 0.1);
        resource1.close();
        resource2.close();
        Assertions.assertThat((boolean)((TestResource)resource1.getResourceHandle()).closed).isTrue();
        Assertions.assertThat((boolean)((TestResource)resource2.getResourceHandle()).closed).isTrue();
        Assertions.assertThat((boolean)memoryManager.verifyEmpty()).isTrue();
    }

    @Test
    void getAllocateExternalResource() throws Exception {
        MemoryManager memoryManager = MemoryManagerSharedResourcesTest.createMemoryManager();
        OpaqueMemoryResource resource = memoryManager.getExternalSharedMemoryResource("external-type", TestResource::new, 1337L);
        Assertions.assertThat((long)resource.getSize()).isEqualTo(1337L);
    }

    @Test
    void getExistingExternalResource() throws Exception {
        MemoryManager memoryManager = MemoryManagerSharedResourcesTest.createMemoryManager();
        OpaqueMemoryResource resource1 = memoryManager.getExternalSharedMemoryResource("external-type", TestResource::new, 1337L);
        OpaqueMemoryResource resource2 = memoryManager.getExternalSharedMemoryResource("external-type", TestResource::new, 1337L);
        Assertions.assertThat((Object)resource2).isNotSameAs((Object)resource1);
        Assertions.assertThat((Object)((TestResource)resource2.getResourceHandle())).isSameAs(resource1.getResourceHandle());
    }

    @Test
    void getDifferentExternalResources() throws Exception {
        MemoryManager memoryManager = MemoryManagerSharedResourcesTest.createMemoryManager();
        OpaqueMemoryResource resource1 = memoryManager.getExternalSharedMemoryResource("external-type-1", TestResource::new, 1337L);
        OpaqueMemoryResource resource2 = memoryManager.getExternalSharedMemoryResource("external-type-2", TestResource::new, 1337L);
        Assertions.assertThat((Object)resource2).isNotSameAs((Object)resource1);
        Assertions.assertThat((Object)((TestResource)resource2.getResourceHandle())).isNotSameAs(resource1.getResourceHandle());
    }

    @Test
    void testReleaseDisposesExternalResource() throws Exception {
        MemoryManager memoryManager = MemoryManagerSharedResourcesTest.createMemoryManager();
        OpaqueMemoryResource resource = memoryManager.getExternalSharedMemoryResource("external-type", TestResource::new, 1337L);
        resource.close();
        Assertions.assertThat((boolean)((TestResource)resource.getResourceHandle()).closed).isTrue();
    }

    @Test
    void testAllocateResourceInitializeFail() {
        MemoryManager memoryManager = MemoryManagerSharedResourcesTest.createMemoryManager();
        Assertions.assertThatExceptionOfType(Throwable.class).isThrownBy(() -> memoryManager.getSharedMemoryResourceForManagedMemory("type", ignore -> {
            throw new RuntimeException("initialization fail");
        }, 0.1));
        Assertions.assertThat((boolean)memoryManager.verifyEmpty()).isTrue();
    }

    private static MemoryManager createMemoryManager() {
        long size = 0x8000000L;
        MemoryManager mm = MemoryManagerBuilder.newBuilder().setMemorySize(0x8000000L).build();
        Assertions.assertThat((long)mm.getMemorySize()).isEqualTo(0x8000000L);
        Assertions.assertThat((long)mm.availableMemory()).isEqualTo(0x8000000L);
        return mm;
    }

    private static final class TestResource
    implements AutoCloseable {
        final long size;
        boolean closed;

        TestResource(long size) {
            this.size = size;
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

