/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotRequestBulk;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotRequestBulkWithTimestamp;
import org.apache.flink.runtime.scheduler.ExecutionSlotSharingGroup;
import org.apache.flink.runtime.scheduler.SharingPhysicalSlotRequestBulk;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;

class TestingPhysicalSlotRequestBulkBuilder {
    private static final BiConsumer<ExecutionVertexID, Throwable> EMPTY_CANCELLER = (r, t) -> {};
    private final Map<ExecutionSlotSharingGroup, List<ExecutionVertexID>> executions = new HashMap<ExecutionSlotSharingGroup, List<ExecutionVertexID>>();
    private final Map<ExecutionSlotSharingGroup, ResourceProfile> pendingRequests = new HashMap<ExecutionSlotSharingGroup, ResourceProfile>();
    private BiConsumer<ExecutionVertexID, Throwable> canceller = EMPTY_CANCELLER;

    TestingPhysicalSlotRequestBulkBuilder() {
    }

    TestingPhysicalSlotRequestBulkBuilder addPendingRequest(ExecutionSlotSharingGroup executionSlotSharingGroup, ResourceProfile resourceProfile) {
        this.pendingRequests.put(executionSlotSharingGroup, resourceProfile);
        this.executions.put(executionSlotSharingGroup, new ArrayList(executionSlotSharingGroup.getExecutionVertexIds()));
        return this;
    }

    TestingPhysicalSlotRequestBulkBuilder setCanceller(BiConsumer<ExecutionVertexID, Throwable> canceller) {
        this.canceller = canceller;
        return this;
    }

    SharingPhysicalSlotRequestBulk buildSharingPhysicalSlotRequestBulk() {
        return new SharingPhysicalSlotRequestBulk(this.executions, this.pendingRequests, this.canceller);
    }

    PhysicalSlotRequestBulkWithTimestamp buildPhysicalSlotRequestBulkWithTimestamp() {
        return new PhysicalSlotRequestBulkWithTimestamp((PhysicalSlotRequestBulk)this.buildSharingPhysicalSlotRequestBulk());
    }

    static TestingPhysicalSlotRequestBulkBuilder newBuilder() {
        return new TestingPhysicalSlotRequestBulkBuilder();
    }
}

