/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Optional;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.slotpool.FreeSlotTracker;
import org.apache.flink.runtime.jobmaster.slotpool.FreeSlotTrackerTestUtils;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;
import org.apache.flink.runtime.scheduler.TestingPhysicalSlot;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;

abstract class SlotSelectionStrategyTestBase {
    protected final ResourceProfile resourceProfile = ResourceProfile.fromResources((double)2.0, (int)1024);
    protected final ResourceProfile biggerResourceProfile = ResourceProfile.fromResources((double)3.0, (int)1024);
    protected final AllocationID aid1 = new AllocationID();
    protected final AllocationID aid2 = new AllocationID();
    protected final AllocationID aid3 = new AllocationID();
    protected final AllocationID aid4 = new AllocationID();
    protected final AllocationID aidX = new AllocationID();
    protected final TaskManagerLocation tml1 = new TaskManagerLocation(new ResourceID("tm-1"), InetAddress.getLoopbackAddress(), 42);
    protected final TaskManagerLocation tml2 = new TaskManagerLocation(new ResourceID("tm-2"), InetAddress.getLoopbackAddress(), 43);
    protected final TaskManagerLocation tml3 = new TaskManagerLocation(new ResourceID("tm-3"), InetAddress.getLoopbackAddress(), 44);
    protected final TaskManagerLocation tml4 = new TaskManagerLocation(new ResourceID("tm-4"), InetAddress.getLoopbackAddress(), 45);
    protected final TaskManagerLocation tmlX = new TaskManagerLocation(new ResourceID("tm-X"), InetAddress.getLoopbackAddress(), 46);
    protected final TaskManagerGateway taskManagerGateway = new SimpleAckingTaskManagerGateway();
    protected final PhysicalSlot slot1 = TestingPhysicalSlot.builder().withAllocationID(this.aid1).withTaskManagerLocation(this.tml1).withPhysicalSlotNumber(1).withTaskManagerGateway(this.taskManagerGateway).withResourceProfile(this.resourceProfile).build();
    protected final PhysicalSlot slot2 = TestingPhysicalSlot.builder().withAllocationID(this.aid2).withTaskManagerLocation(this.tml2).withPhysicalSlotNumber(2).withTaskManagerGateway(this.taskManagerGateway).withResourceProfile(this.biggerResourceProfile).build();
    protected final PhysicalSlot slot3 = TestingPhysicalSlot.builder().withAllocationID(this.aid3).withTaskManagerLocation(this.tml3).withPhysicalSlotNumber(3).withTaskManagerGateway(this.taskManagerGateway).withResourceProfile(this.resourceProfile).build();
    protected final PhysicalSlot slot4 = TestingPhysicalSlot.builder().withAllocationID(this.aid4).withTaskManagerLocation(this.tml4).withPhysicalSlotNumber(4).withTaskManagerGateway(this.taskManagerGateway).withResourceProfile(this.resourceProfile).build();
    protected final FreeSlotTracker candidates = this.createCandidates();
    protected SlotSelectionStrategy selectionStrategy;

    SlotSelectionStrategyTestBase() {
    }

    private FreeSlotTracker createCandidates() {
        HashMap<AllocationID, PhysicalSlot> candidates = new HashMap<AllocationID, PhysicalSlot>(4);
        candidates.put(this.slot1.getAllocationId(), this.slot1);
        candidates.put(this.slot2.getAllocationId(), this.slot2);
        candidates.put(this.slot3.getAllocationId(), this.slot3);
        candidates.put(this.slot4.getAllocationId(), this.slot4);
        return FreeSlotTrackerTestUtils.createDefaultFreeSlotTracker(candidates);
    }

    protected Optional<SlotSelectionStrategy.SlotInfoAndLocality> runMatching(SlotProfile slotProfile) {
        return this.selectionStrategy.selectBestSlotForProfile(this.candidates, slotProfile);
    }
}

