/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.event;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.IntCounter;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.IOMetrics;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobmaster.event.ExecutionVertexFinishedEvent;
import org.apache.flink.runtime.jobmaster.event.JobEvent;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.function.BiFunctionWithException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ExecutionVertexFinishedEventTest {
    ExecutionVertexFinishedEventTest() {
    }

    @Test
    void testExecutionVertexFinishedEventSerializer() throws Exception {
        TaskManagerLocation taskManagerLocation = new TaskManagerLocation(new ResourceID("tm-X"), InetAddress.getLoopbackAddress(), 46);
        HashMap<OperatorID, byte[]> operatorCoordinatorSnapshots = new HashMap<OperatorID, byte[]>();
        byte[] bytes = new byte[2000];
        for (int i = 0; i < 3; ++i) {
            new Random(i).nextBytes(bytes);
            operatorCoordinatorSnapshots.put(new OperatorID(), bytes);
        }
        HashMap operatorCoordinatorSnapshotFutures = new HashMap();
        operatorCoordinatorSnapshots.forEach((key, value) -> operatorCoordinatorSnapshotFutures.put(key, CompletableFuture.completedFuture(value)));
        IOMetrics ioMetrics = new IOMetrics(1L, 2L, 3L, 4L, 5L, 6.0, 7L);
        HashMap<String, IntCounter> accumulators = new HashMap<String, IntCounter>();
        accumulators.put("acc", new IntCounter(8));
        ExecutionVertexFinishedEvent event = new ExecutionVertexFinishedEvent(ExecutionGraphTestUtils.createExecutionAttemptId(), taskManagerLocation, operatorCoordinatorSnapshotFutures, null, ioMetrics, accumulators);
        ExecutionVertexFinishedEvent.Serializer serializer = new ExecutionVertexFinishedEvent.Serializer();
        byte[] binaryLog = serializer.serialize((JobEvent)event);
        ExecutionVertexFinishedEvent deserializedEvent = (ExecutionVertexFinishedEvent)serializer.deserialize(serializer.getVersion(), binaryLog);
        Assertions.assertThat((Object)event.getExecutionVertexId()).isEqualTo((Object)deserializedEvent.getExecutionVertexId());
        Assertions.assertThat((int)event.getAttemptNumber()).isEqualTo(deserializedEvent.getAttemptNumber());
        Assertions.assertThat((Comparable)event.getTaskManagerLocation()).isEqualTo((Object)deserializedEvent.getTaskManagerLocation());
        Assertions.assertThat((boolean)ExecutionVertexFinishedEventTest.snapshotsEquals(event.getOperatorCoordinatorSnapshotFutures(), deserializedEvent.getOperatorCoordinatorSnapshotFutures())).isTrue();
        Assertions.assertThat((boolean)ExecutionVertexFinishedEventTest.userAccumulatorsEquals(event.getUserAccumulators(), deserializedEvent.getUserAccumulators())).isTrue();
        Assertions.assertThat((boolean)ExecutionVertexFinishedEventTest.ioMetricsEquals(event.getIOMetrics(), deserializedEvent.getIOMetrics())).isTrue();
    }

    private static boolean ioMetricsEquals(IOMetrics ioMetricsA, IOMetrics ioMetricsB) {
        return ioMetricsA.getNumBytesIn() == ioMetricsB.getNumBytesIn() && ioMetricsA.getNumBytesOut() == ioMetricsB.getNumBytesOut() && ioMetricsA.getNumRecordsIn() == ioMetricsB.getNumRecordsIn() && ioMetricsA.getNumRecordsOut() == ioMetricsB.getNumRecordsOut();
    }

    private static boolean userAccumulatorsEquals(Map<String, Accumulator<?, ?>> userAccumulatorsA, Map<String, Accumulator<?, ?>> userAccumulatorsB) throws Exception {
        return ExecutionVertexFinishedEventTest.mapEquals(userAccumulatorsA, userAccumulatorsB, (accumulatorA, accumulatorB) -> accumulatorA.getLocalValue().equals(accumulatorB.getLocalValue()));
    }

    private static boolean snapshotsEquals(Map<OperatorID, CompletableFuture<byte[]>> snapshotsA, Map<OperatorID, CompletableFuture<byte[]>> snapshotsB) throws Exception {
        return ExecutionVertexFinishedEventTest.mapEquals(snapshotsA, snapshotsB, (futureA, futureB) -> Arrays.equals((byte[])futureA.get(), (byte[])futureB.get()));
    }

    private static <K, V> boolean mapEquals(Map<K, V> mapA, Map<K, V> mapB, BiFunctionWithException<V, V, Boolean, Exception> valueComparator) throws Exception {
        if (mapA.size() == mapB.size() && mapA.keySet().containsAll(mapB.keySet())) {
            for (Map.Entry<K, V> entry : mapA.entrySet()) {
                if (((Boolean)valueComparator.apply(entry.getValue(), mapB.get(entry.getKey()))).booleanValue()) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

