/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphTestUtils;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.jobmaster.TestingAbstractInvokables;
import org.apache.flink.runtime.minicluster.TestingMiniCluster;
import org.apache.flink.runtime.minicluster.TestingMiniClusterConfiguration;
import org.apache.flink.runtime.util.JobVertexConnectionUtils;
import org.apache.flink.streaming.api.graph.ExecutionPlan;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class JobExecutionITCase {
    JobExecutionITCase() {
    }

    @Test
    void testCoLocationConstraintJobExecution() throws Exception {
        boolean numSlotsPerTaskExecutor = true;
        int numTaskExecutors = 3;
        int parallelism = 3;
        JobGraph jobGraph = this.createJobGraph(3);
        TestingMiniClusterConfiguration miniClusterConfiguration = TestingMiniClusterConfiguration.newBuilder().setNumSlotsPerTaskManager(1).setNumTaskManagers(3).setLocalCommunication(true).build();
        try (TestingMiniCluster miniCluster = TestingMiniCluster.newBuilder(miniClusterConfiguration).build();){
            miniCluster.start();
            miniCluster.submitJob((ExecutionPlan)jobGraph).get();
            CompletableFuture jobResultFuture = miniCluster.requestJobResult(jobGraph.getJobID());
            Assertions.assertThat((boolean)((JobResult)jobResultFuture.get()).isSuccess()).isTrue();
        }
    }

    private JobGraph createJobGraph(int parallelism) {
        JobVertex sender = new JobVertex("Sender");
        sender.setParallelism(parallelism);
        sender.setInvokableClass(TestingAbstractInvokables.Sender.class);
        JobVertex receiver = new JobVertex("Receiver");
        receiver.setParallelism(parallelism);
        receiver.setInvokableClass(TestingAbstractInvokables.Receiver.class);
        SlotSharingGroup slotSharingGroup = new SlotSharingGroup();
        receiver.setSlotSharingGroup(slotSharingGroup);
        sender.setSlotSharingGroup(slotSharingGroup);
        receiver.setStrictlyCoLocatedWith(sender);
        JobVertexConnectionUtils.connectNewDataSetAsInput(receiver, sender, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
        return JobGraphTestUtils.streamingJobGraph(sender, receiver);
    }
}

