/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageInputChannelId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.AvailabilityNotifier;

public class TestingAvailabilityNotifier
implements AvailabilityNotifier {
    private final BiFunction<TieredStoragePartitionId, TieredStorageInputChannelId, CompletableFuture<Void>> notifyFunction;

    public TestingAvailabilityNotifier(BiFunction<TieredStoragePartitionId, TieredStorageInputChannelId, CompletableFuture<Void>> notifyFunction) {
        this.notifyFunction = notifyFunction;
    }

    public void notifyAvailable(TieredStoragePartitionId partitionId, TieredStorageInputChannelId inputChannelId) {
        this.notifyFunction.apply(partitionId, inputChannelId);
    }

    public static class Builder {
        private BiFunction<TieredStoragePartitionId, TieredStorageInputChannelId, CompletableFuture<Void>> notifyFunction = (partitionId, subpartitionId) -> new CompletableFuture();

        public Builder setNotifyFunction(BiFunction<TieredStoragePartitionId, TieredStorageInputChannelId, CompletableFuture<Void>> notifyFunction) {
            this.notifyFunction = notifyFunction;
            return this;
        }

        public TestingAvailabilityNotifier build() {
            return new TestingAvailabilityNotifier(this.notifyFunction);
        }
    }
}

