/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.common;

import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilderTestUtils;
import org.apache.flink.runtime.io.network.partition.BufferReaderWriterUtil;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TieredStorageUtilsTest {
    TieredStorageUtilsTest() {
    }

    @Test
    void testGenerateBufferWithHeaders() {
        int bufferBytes = 5;
        Buffer originalBuffer = BufferBuilderTestUtils.buildSomeBuffer(bufferBytes);
        ByteBuffer header = BufferReaderWriterUtil.allocatedHeaderBuffer();
        BufferReaderWriterUtil.setByteChannelBufferHeader((Buffer)originalBuffer, (ByteBuffer)header);
        Object[] byteBuffers = TieredStorageUtils.generateBufferWithHeaders(Collections.singletonList(new Tuple2((Object)BufferBuilderTestUtils.buildSomeBuffer(bufferBytes), (Object)0)));
        Assertions.assertThat((Object[])byteBuffers).hasSize(2);
        Assertions.assertThat((Comparable)byteBuffers[0]).isEqualTo((Object)header);
        Assertions.assertThat((Comparable)byteBuffers[1]).isEqualTo((Object)originalBuffer.getNioBufferReadable());
    }
}

