/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.utils;

import java.time.Duration;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.PartitionInfo;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.function.TriConsumer;

public class SimpleAckingTaskManagerGateway
implements TaskManagerGateway {
    private final String address = UUID.randomUUID().toString();
    private Consumer<TaskDeploymentDescriptor> submitConsumer = ignore -> {};
    private Consumer<ExecutionAttemptID> cancelConsumer = ignore -> {};
    private volatile BiFunction<AllocationID, Throwable, CompletableFuture<Acknowledge>> freeSlotFunction;
    private BiConsumer<JobID, Collection<ResultPartitionID>> releasePartitionsConsumer = (ignore1, ignore2) -> {};
    private CheckpointConsumer checkpointConsumer = (executionAttemptID, jobId, checkpointId, timestamp, checkpointOptions) -> {};
    private TriConsumer<ExecutionAttemptID, Iterable<PartitionInfo>, Duration> updatePartitionsConsumer = (ignore1, ignore2, ignore3) -> {};

    public void setSubmitConsumer(Consumer<TaskDeploymentDescriptor> submitConsumer) {
        this.submitConsumer = submitConsumer;
    }

    public void setCancelConsumer(Consumer<ExecutionAttemptID> cancelConsumer) {
        this.cancelConsumer = cancelConsumer;
    }

    public void setFreeSlotFunction(BiFunction<AllocationID, Throwable, CompletableFuture<Acknowledge>> freeSlotFunction) {
        this.freeSlotFunction = freeSlotFunction;
    }

    public void setReleasePartitionsConsumer(BiConsumer<JobID, Collection<ResultPartitionID>> releasePartitionsConsumer) {
        this.releasePartitionsConsumer = releasePartitionsConsumer;
    }

    public void setCheckpointConsumer(CheckpointConsumer checkpointConsumer) {
        this.checkpointConsumer = checkpointConsumer;
    }

    public void setUpdatePartitionsConsumer(TriConsumer<ExecutionAttemptID, Iterable<PartitionInfo>, Duration> updatePartitionsConsumer) {
        this.updatePartitionsConsumer = updatePartitionsConsumer;
    }

    public String getAddress() {
        return this.address;
    }

    public CompletableFuture<Acknowledge> submitTask(TaskDeploymentDescriptor tdd, Duration timeout) {
        this.submitConsumer.accept(tdd);
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    public CompletableFuture<Acknowledge> cancelTask(ExecutionAttemptID executionAttemptID, Duration timeout) {
        this.cancelConsumer.accept(executionAttemptID);
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    public CompletableFuture<Acknowledge> updatePartitions(ExecutionAttemptID executionAttemptID, Iterable<PartitionInfo> partitionInfos, Duration timeout) {
        this.updatePartitionsConsumer.accept((Object)executionAttemptID, partitionInfos, (Object)timeout);
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    public void releasePartitions(JobID jobId, Set<ResultPartitionID> partitionIds) {
        this.releasePartitionsConsumer.accept(jobId, partitionIds);
    }

    public void notifyCheckpointOnComplete(ExecutionAttemptID executionAttemptID, JobID jobId, long completedCheckpointId, long completedTimestamp, long lastSubsumedCheckpointId) {
    }

    public void notifyCheckpointAborted(ExecutionAttemptID executionAttemptID, JobID jobId, long checkpointId, long latestCompletedCheckpointId, long timestamp) {
    }

    public CompletableFuture<Acknowledge> triggerCheckpoint(ExecutionAttemptID executionAttemptID, JobID jobId, long checkpointId, long timestamp, CheckpointOptions checkpointOptions) {
        this.checkpointConsumer.accept(executionAttemptID, jobId, checkpointId, timestamp, checkpointOptions);
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    public CompletableFuture<Acknowledge> sendOperatorEventToTask(ExecutionAttemptID task, OperatorID operator, SerializedValue<OperatorEvent> evt) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Acknowledge> freeSlot(AllocationID allocationId, Throwable cause, Duration timeout) {
        BiFunction<AllocationID, Throwable, CompletableFuture<Acknowledge>> currentFreeSlotFunction = this.freeSlotFunction;
        if (currentFreeSlotFunction != null) {
            return currentFreeSlotFunction.apply(allocationId, cause);
        }
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    public static interface CheckpointConsumer {
        public void accept(ExecutionAttemptID var1, JobID var2, long var3, long var5, CheckpointOptions var7);
    }
}

