/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover.partitionrelease;

import java.util.Collections;
import org.apache.flink.runtime.executiongraph.failover.partitionrelease.PipelinedRegionExecutionView;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.SchedulingPipelinedRegion;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingPipelinedRegion;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PipelinedRegionExecutionViewTest {
    private static final ExecutionVertexID TEST_EXECUTION_VERTEX_ID = new ExecutionVertexID(new JobVertexID(), 0);
    private static final TestingSchedulingPipelinedRegion TEST_PIPELINED_REGION = new TestingSchedulingPipelinedRegion(Collections.singleton(TestingSchedulingExecutionVertex.withExecutionVertexID(TEST_EXECUTION_VERTEX_ID.getJobVertexId(), TEST_EXECUTION_VERTEX_ID.getSubtaskIndex())));

    PipelinedRegionExecutionViewTest() {
    }

    @Test
    public void regionIsUnfinishedIfNotAllVerticesAreFinished() {
        PipelinedRegionExecutionView pipelinedRegionExecutionView = new PipelinedRegionExecutionView((SchedulingPipelinedRegion)TEST_PIPELINED_REGION);
        Assertions.assertThat((boolean)pipelinedRegionExecutionView.isFinished()).isFalse();
    }

    @Test
    public void regionIsFinishedIfAllVerticesAreFinished() {
        PipelinedRegionExecutionView pipelinedRegionExecutionView = new PipelinedRegionExecutionView((SchedulingPipelinedRegion)TEST_PIPELINED_REGION);
        pipelinedRegionExecutionView.vertexFinished(TEST_EXECUTION_VERTEX_ID);
        Assertions.assertThat((boolean)pipelinedRegionExecutionView.isFinished()).isTrue();
    }

    @Test
    public void vertexCanBeUnfinished() {
        PipelinedRegionExecutionView pipelinedRegionExecutionView = new PipelinedRegionExecutionView((SchedulingPipelinedRegion)TEST_PIPELINED_REGION);
        pipelinedRegionExecutionView.vertexFinished(TEST_EXECUTION_VERTEX_ID);
        pipelinedRegionExecutionView.vertexUnfinished(TEST_EXECUTION_VERTEX_ID);
        Assertions.assertThat((boolean)pipelinedRegionExecutionView.isFinished()).isFalse();
    }

    @Test
    public void finishingUnknownVertexThrowsException() {
        PipelinedRegionExecutionView pipelinedRegionExecutionView = new PipelinedRegionExecutionView((SchedulingPipelinedRegion)TEST_PIPELINED_REGION);
        ExecutionVertexID unknownVertexId = new ExecutionVertexID(new JobVertexID(), 0);
        Assertions.assertThatThrownBy(() -> pipelinedRegionExecutionView.vertexFinished(unknownVertexId)).isInstanceOf(IllegalArgumentException.class);
    }
}

