/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Arrays;
import java.util.Collections;
import org.apache.flink.runtime.checkpoint.InflightDataRescalingDescriptor;
import org.apache.flink.runtime.checkpoint.RescaleMappings;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class InflightDataRescalingDescriptorTest {
    InflightDataRescalingDescriptorTest() {
    }

    @Test
    void testNoStateDescriptorReturnsEmptyOldSubtaskInstances() {
        InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor noStateDescriptor = InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor.NO_STATE;
        Assertions.assertThat((int[])noStateDescriptor.getOldSubtaskInstances()).isEqualTo((Object)new int[0]);
    }

    @Test
    void testNoStateDescriptorReturnsSymmetricIdentity() {
        InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor noStateDescriptor = InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor.NO_STATE;
        Assertions.assertThat((Object)noStateDescriptor.getRescaleMappings()).isEqualTo((Object)RescaleMappings.SYMMETRIC_IDENTITY);
    }

    @Test
    void testNoStateDescriptorIsIdentity() {
        InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor noStateDescriptor = InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor.NO_STATE;
        Assertions.assertThat((boolean)noStateDescriptor.isIdentity()).isTrue();
    }

    @Test
    void testRegularDescriptorDoesNotThrow() {
        int[] oldSubtasks = new int[]{0, 1, 2};
        RescaleMappings mappings = RescaleMappings.of(Arrays.stream(new int[][]{{0}, {1}, {2}}), (int)3);
        InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor descriptor = new InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor(oldSubtasks, mappings, Collections.emptySet(), InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor.MappingType.RESCALING);
        Assertions.assertThat((int[])descriptor.getOldSubtaskInstances()).isEqualTo((Object)oldSubtasks);
        Assertions.assertThat((Object)descriptor.getRescaleMappings()).isEqualTo((Object)mappings);
        Assertions.assertThat((boolean)descriptor.isIdentity()).isFalse();
    }

    @Test
    void testIdentityDescriptor() {
        int[] oldSubtasks = new int[]{0};
        RescaleMappings mappings = RescaleMappings.identity((int)1, (int)1);
        InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor descriptor = new InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor(oldSubtasks, mappings, Collections.emptySet(), InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor.MappingType.IDENTITY);
        Assertions.assertThat((boolean)descriptor.isIdentity()).isTrue();
        Assertions.assertThat((int[])descriptor.getOldSubtaskInstances()).isEqualTo((Object)oldSubtasks);
        Assertions.assertThat((Object)descriptor.getRescaleMappings()).isEqualTo((Object)mappings);
    }

    @Test
    void testInflightDataRescalingDescriptorWithNoStateDescriptor() {
        InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor[] descriptors = new InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor[]{InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor.NO_STATE, new InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor(new int[]{0, 1}, RescaleMappings.of(Arrays.stream(new int[][]{{0}, {1}}), (int)2), Collections.emptySet(), InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor.MappingType.RESCALING)};
        InflightDataRescalingDescriptor rescalingDescriptor = new InflightDataRescalingDescriptor(descriptors);
        Assertions.assertThat((int[])rescalingDescriptor.getOldSubtaskIndexes(0)).isEqualTo((Object)new int[0]);
        Assertions.assertThat((Object)rescalingDescriptor.getChannelMapping(0)).isEqualTo((Object)RescaleMappings.SYMMETRIC_IDENTITY);
        Assertions.assertThat((int[])rescalingDescriptor.getOldSubtaskIndexes(1)).isEqualTo((Object)new int[]{0, 1});
        Assertions.assertThat((Object)rescalingDescriptor.getChannelMapping(1)).isNotNull();
    }
}

